/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Range;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="rangeData")
@NamedQueries(value={@NamedQuery(name="rangeData.getAll", query="from rangeData"), @NamedQuery(name="rangeData.getRangeDataById", query="from rangeData where range.id= :rangeId")})
public class RangeData {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="value cannot be blank")
    private @NotBlank(message="value cannot be blank") String value;
    @ManyToOne
    @JoinColumn(name="range_id", nullable=false)
    private Range range;
    protected static Logger logger = LoggerFactory.getLogger(RangeData.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Range getRange() {
        if (logger.isTraceEnabled()) {
            logger.trace("getRange() - Returning range for field ID: " + this.getId());
        }
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", value=");
        builder.append(this.getValue());
        builder.append(", range_id=");
        builder.append(this.getRange().getId());
        builder.append("]");
        return builder.toString();
    }
}

