/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.RangeData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="range")
@NamedQuery(name="range.getAll", query="from range")
public class Range {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="name is blank")
    private @NotBlank(message="name is blank") String name;
    @NotBlank(message="description is blank")
    private @NotBlank(message="description is blank") String description;
    private String fromRange;
    private String toRange;
    @OneToMany(mappedBy="range")
    private Set<RangeData> rangeData;
    @NotNull(message="interval cannnot be null")
    private @NotNull(message="interval cannnot be null") boolean interval;
    protected static Logger logger = LoggerFactory.getLogger(Range.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFromRange() {
        return this.fromRange;
    }

    public void setFromRange(String fromRange) {
        this.fromRange = fromRange;
    }

    public String getToRange() {
        return this.toRange;
    }

    public void setToRange(String toRange) {
        this.toRange = toRange;
    }

    public Set<RangeData> getRangeData() {
        return this.rangeData;
    }

    public void setRangeData(Set<RangeData> rangeData) {
        this.rangeData = rangeData;
    }

    public boolean isInterval() {
        return this.interval;
    }

    public void setInterval(boolean interval) {
        this.interval = interval;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", isInterval=");
        builder.append(this.isInterval());
        if (this.isInterval()) {
            builder.append(", from=");
            builder.append(this.getFromRange());
            builder.append(", to=");
            builder.append(this.getToRange());
        }
        builder.append("] ");
        return builder.toString();
    }
}

