/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Protocol;
import eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

@Entity(name="protocolToRule")
@NamedQueries(value={@NamedQuery(name="protocolToRule.getAll", query="from protocolToRule"), @NamedQuery(name="protocolToRule.getByProtocolID", query="from protocolToRule where protocol.id = : protocolID"), @NamedQuery(name="protocolToRule.getByRuleID", query="from protocolToRule where ruleDefinition.id = : ruleID"), @NamedQuery(name="protocolToRule.getProtocolsByRuleID", query="select protocol from protocolToRule where ruleDefinition.id = : ruleID"), @NamedQuery(name="protocolToRule.getProtocolsIDsByRuleID", query="select protocol.id from protocolToRule where ruleDefinition.id = : ruleID"), @NamedQuery(name="protocolToRule.getRulesByProtocolID", query="select ruleDefinition from protocolToRule where protocol.id = : protocolID"), @NamedQuery(name="protocolToRule.getRulesIDsByProtocolID", query="select ruleDefinition.id from protocolToRule where protocol.id = : protocolID")})
public class ProtocolToRule {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne
    private Protocol protocol;
    @Min(value=1L)
    private @Min(value=1L) Integer priority;
    @NotNull(message="block cannot be null")
    private @NotNull(message="block cannot be null") Boolean block;
    @ManyToOne
    private RuleDefinition ruleDefinition;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Boolean getBlock() {
        return this.block;
    }

    public void setBlock(Boolean block) {
        this.block = block;
    }

    public RuleDefinition getRuleDefinition() {
        return this.ruleDefinition;
    }

    public void setRuleDefinition(RuleDefinition ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("[");
        builder.append("id=");
        builder.append(this.getId());
        builder.append(", protocolID=");
        builder.append(this.getProtocol().getId());
        builder.append(", priority=");
        builder.append(this.getPriority());
        builder.append(", block=");
        builder.append(this.getBlock());
        builder.append(", ruleID=");
        builder.append(this.getRuleDefinition().getId());
        builder.append("]");
        return builder.toString();
    }
}

