/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="protocol")
@NamedQueries(value={@NamedQuery(name="protocol.getAll", query="from protocol"), @NamedQuery(name="protocol.getAllByOrder", query="from protocol ORDER BY orderNumber"), @NamedQuery(name="protocol.getAllActiveByOrder", query="from protocol where orderNumber>0 ORDER BY orderNumber"), @NamedQuery(name="protocol.getBySchemaID", query="from protocol WHERE schema.id = :schemaID")})
public class Protocol {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="name cannot be blank")
    private @NotBlank(message="name cannot be blank") String name;
    @NotBlank(message="description cannot be blank")
    private @NotBlank(message="description cannot be blank") String description;
    @Min(value=0L)
    private @Min(value=0L) Integer orderNumber;
    @ManyToOne(optional=true)
    private Protocol parent;
    @ManyToOne(optional=false)
    private Schema schema;
    protected static Logger logger = LoggerFactory.getLogger(Protocol.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Protocol getParent() {
        return this.parent;
    }

    public void setParent(Protocol parent) {
        this.parent = parent;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("name=");
        builder.append(this.name);
        builder.append(", id=");
        builder.append(this.getId());
        builder.append(", order=");
        builder.append(this.getOrderNumber());
        builder.append(", schemaID=");
        builder.append(this.getSchema().getId());
        builder.append(", parentID=");
        builder.append(this.getParent().getId());
        builder.append("]");
        return builder.toString();
    }
}

