/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.dto;

import eu.europa.ec.jrc.qcs.dao.dto.Range;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="field")
@NamedQuery(name="field.getAll", query="from field")
public class Field {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @NotBlank(message="functionId is blank")
    private @NotBlank(message="functionId is blank") String functionId;
    @Pattern(regexp="[NUPCM]|PM|PC", message="Invalid key value. Enter N or U or P or C or M.")
    @Size(min=1, max=2, message="Invalid key size")
    private @Pattern(regexp="[NUPCM]|PM|PC", message="Invalid key value. Enter N or U or P or C or M.") @Size(min=1, max=2, message="Invalid key size") String key;
    @NotBlank(message="name is blank")
    private @NotBlank(message="name is blank") String name;
    @NotBlank(message="description is blank")
    private @NotBlank(message="description is blank") String description;
    @Pattern(regexp="[NAF]", message="Invalid dataType value. Enter N or A or F.")
    private @Pattern(regexp="[NAF]", message="Invalid dataType value. Enter N or A or F.") String dataType;
    @Min(value=1L)
    private @Min(value=1L) int fieldSize;
    @NotNull(message="fieldCase cannnot be null")
    private @NotNull(message="fieldCase cannnot be null") boolean fieldCase;
    @Pattern(regexp="[012]", message="Invalid mandatory value. Enter 0 or 1 or 2.")
    private @Pattern(regexp="[012]", message="Invalid mandatory value. Enter 0 or 1 or 2.") String mandatory;
    private String unknownValue;
    @NotEmpty(message="defaultValue is empty")
    private @NotEmpty(message="defaultValue is empty") String defaultValue;
    @ManyToOne(optional=true)
    private Range range;
    protected static Logger logger = LoggerFactory.getLogger(Field.class);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public void setFieldSize(int fieldSize) {
        this.fieldSize = fieldSize;
    }

    public boolean isFieldCase() {
        return this.fieldCase;
    }

    public void setFieldCase(boolean fieldCase) {
        this.fieldCase = fieldCase;
    }

    public String getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(String mandatory) {
        this.mandatory = mandatory;
    }

    public String getUnknownValue() {
        return this.unknownValue;
    }

    public void setUnknownValue(String unknownValue) {
        this.unknownValue = unknownValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Range getRange() {
        if (logger.isTraceEnabled()) {
            logger.trace("getRange() - Returning range for field ID: " + this.getId());
        }
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String toPrettyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("");
        builder.append("Name           : ");
        builder.append(this.name);
        builder.append("\n");
        builder.append("Description    : ");
        builder.append(this.description);
        builder.append("\n");
        builder.append("Field ID       : ");
        builder.append(this.getId());
        builder.append("\n");
        builder.append("DataType       : ");
        builder.append(this.dataType);
        builder.append("\n");
        builder.append("Size           : ");
        builder.append(this.getFieldSize());
        builder.append("\n");
        builder.append("Mandatory      : ");
        builder.append(this.mandatory);
        builder.append("\n");
        builder.append("Case Sensitive : ");
        builder.append(this.isFieldCase());
        builder.append("\n");
        builder.append("Key Type       : ");
        builder.append(this.getKey());
        builder.append("\n");
        builder.append("Unknown Value  : ");
        builder.append(this.getUnknownValue());
        builder.append("\n");
        builder.append("Default Value  : ");
        builder.append(this.defaultValue);
        builder.append("\n");
        if (this.range != null) {
            builder.append("Range          : ");
            builder.append(this.range);
            builder.append("\n");
            builder.append("Range's source : ");
            builder.append(this.range.getDescription());
            builder.append("\n");
            builder.append("Range's type   : ");
            builder.append(this.range.isInterval() ? "interval" : "enumeration");
            builder.append("\n");
        } else {
            builder.append("Range          : null");
        }
        return builder.toString();
    }
}

