/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileDAOFactory
extends DAOFactory {
    protected static Logger logger = LoggerFactory.getLogger(FlatFileDAOFactory.class);

    private FlatFileDAOFactory() {
        this.cached = true;
    }

    public static FlatFileDAOFactory getInstance() {
        FlatFileDAOFactory daoFactory = DAOFactorySingleton.SINGLETON.get();
        if (logger.isTraceEnabled()) {
            logger.trace("Retrieved DAO factory singleton: " + String.valueOf(daoFactory));
        }
        return daoFactory;
    }

    public static FileConnection getConnection(DAO dao) {
        FlatFile flatFile = dao.fileDAO;
        if (logger.isTraceEnabled()) {
            logger.trace("getConnection(DAO) - Using flat file: " + String.valueOf((Object)flatFile));
        }
        if (flatFile != null) {
            return FlatFileDAOFactory.getConnection(flatFile);
        }
        throw new IllegalStateException("DAO:" + String.valueOf((Object)dao) + " has a null flat-file enum entry");
    }

    public static FileConnection getConnection(FlatFile flatFile) {
        if (logger.isTraceEnabled()) {
            logger.trace("getConnection(DAO) -Fetching connection for file: " + String.valueOf((Object)flatFile));
        }
        if (flatFile.isDynamic()) {
            return new DynamicFileConnection(flatFile);
        }
        return new FileConnection(flatFile);
    }

    @Override
    public GenericHandler<?> getDAO(DAO dao) {
        GenericHandler<?> daoObject = null;
        if (logger.isTraceEnabled()) {
            logger.trace("Getting dao: " + String.valueOf((Object)dao));
        }
        if (this.cached && (daoObject = (GenericHandler<?>)this.daoMAP.get((Object)dao)) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Cache hit -> returning existing dao: " + String.valueOf(daoObject));
            }
            return daoObject;
        }
        FlatFile flatFile = dao.fileDAO;
        if (flatFile == null) {
            throw new IllegalStateException("DAO:" + String.valueOf((Object)dao) + " has a null flat-file enum entry");
        }
        daoObject = this.getFlatFileDAO(flatFile);
        if (this.cached) {
            this.daoMAP.put(dao, daoObject);
            if (logger.isDebugEnabled()) {
                logger.debug("Cache miss -> cached new dao: " + String.valueOf(daoObject));
            }
        }
        return daoObject;
    }

    private GenericHandler<?> getFlatFileDAO(FlatFile flatFile) {
        FileConnection fileConnection = FlatFileDAOFactory.getConnection(flatFile);
        Object concreteDAO = null;
        String canonicalName = "eu.europa.ec.jrc.qcs.dao.file." + flatFile.dao;
        if (logger.isTraceEnabled()) {
            logger.trace("Getting DAO instance : " + canonicalName);
        }
        try {
            Class<?> type = Class.forName(canonicalName);
            Constructor<?> constructor = type.getConstructor(FileConnection.class);
            concreteDAO = constructor.newInstance(fileConnection);
            if (logger.isTraceEnabled()) {
                logger.trace("Loaded DAO instance : " + String.valueOf(concreteDAO));
            }
        }
        catch (Exception e) {
            logger.error("Error creating class " + canonicalName + ":" + e.getMessage());
        }
        return concreteDAO;
    }

    private static class DAOFactorySingleton {
        public static ThreadLocal<FlatFileDAOFactory> SINGLETON;
        protected static Logger logger;

        private DAOFactorySingleton() {
        }

        static {
            logger = LoggerFactory.getLogger(DAOFactorySingleton.class);
            ThreadLocal<FlatFileDAOFactory> daoFactory = null;
            String thread = Thread.currentThread().getName();
            if (logger.isDebugEnabled()) {
                logger.debug("static - Creating DAOFactorySingleton instance (static thread local) for thread: " + thread);
            }
            try {
                daoFactory = new ThreadLocal<FlatFileDAOFactory>(){

                    @Override
                    protected FlatFileDAOFactory initialValue() {
                        try {
                            if (logger.isInfoEnabled()) {
                                String thread = Thread.currentThread().getName();
                                logger.info("initialValue() - Creating DAOFactory singleton (initial value) for thread: " + thread);
                            }
                            return new FlatFileDAOFactory();
                        }
                        catch (Exception e) {
                            logger.error("initialValue() - Failed creation of the singleton instance: " + e.getMessage());
                            return null;
                        }
                        catch (Throwable t) {
                            logger.error("initialValue() - Fatal error when creating singleton instance: " + t.getMessage());
                            return null;
                        }
                    }
                };
            }
            catch (Exception e) {
                daoFactory = null;
                logger.error("static: Failed creation of the thread local singleton: " + e.getMessage());
            }
            catch (Throwable t) {
                logger.error("static: Fatal error when creating singleton instance: " + t.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("static - Created DAOFactorySingleton instance (static thread local): " + String.valueOf(daoFactory));
            }
            SINGLETON = daoFactory;
        }
    }
}

