/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

public enum FlatFile {
    UNDEF("For DAOs not based on the FlatFile architecture", null, null, null, null),
    PROPERTIES("Main configuration file (a property file)", "configuration", null, "application.properties", "ApplicationPropertiesDAOImpl"),
    LOGGER_CONFIG("Standard Log4j XML configuration file", "configuration", null, "log4j2.xml", "LoggerConfigurationDAOImpl"),
    I18N_CONFIG("Bundle for all properties requiring i18n", "configuration", null, "labels.properties", "InternationalizationDAOImpl"),
    OPTIONS("Bundle for all validation options", "configuration", null, "validation.properties", "ValidationOptionsDAOImpl"),
    SCHEMAS_GROUP("Definition of schemas groups", "configuration/schema", null, "schemas_group.csv", "SchemaGroupDAOImpl"),
    SCHEMA("Definition of specific validation schemas", "configuration/schema", null, "schema.csv", "SchemaDAOImpl"),
    FIELD("Definition of fields belonging to schemas", "configuration/schema", "SUB_DIRECTORY", "fields_list_RESOURCE_ID.csv", "FieldDAOImpl"),
    SCHEMA_TO_FIELD("Link configuration between fields and schemas", "configuration/schema", "SUB_DIRECTORY", "schema_to_field_RESOURCE_ID.csv", "SchemaToFieldDAOImpl"),
    RANGE("Definition of ranges for a single schemas", "configuration/schema", "SUB_DIRECTORY", "ranges_list_RESOURCE_ID.csv", "RangeDAOImpl"),
    RANGE_DATA("Set of allowed values in a single range", "configuration/schema", "SUB_DIRECTORY", "range_data_RESOURCE_ID.txt", "RangeDataDAOImpl"),
    SCHEMA_VIEW("View showing all schema information", "configuration/schema", "SUB_DIRECTORY", "schema_to_field_RESOURCE_ID.csv", "SchemaViewDAOImpl"),
    RULE_DEFINITION("Definition of specific validation rules", "configuration/protocol", null, "rule_definition.csv", "RuleDefinitionDAOImpl"),
    PROTOCOL("Definition of validation rule sets", "configuration/protocol", null, "protocol.csv", "ProtocolDAOImpl"),
    PROTOCOL_TO_RULE("Link configuration between protocols and rules", "configuration/protocol", "SUB_DIRECTORY", "protocol_to_rule_RESOURCE_ID.csv", "ProtocolToRuleDAOImpl"),
    RULE_TO_FIELD("Link configuration between rules and fields", "configuration/protocol", "SUB_DIRECTORY", "rule_to_field_RESOURCE_ID.csv", "RuleToFieldDAOImpl"),
    VALIDATION_MESSAGE("Definition of error/warning messages", "configuration/protocol", null, "validation_message.csv", "ValidationMessageDAOImpl"),
    DATA_RECORD("The input file to be validated", null, null, null, "DataRecordDAOImpl"),
    DATA_RECORD_CORRECT("The file where \"perfectly clean\" records are saved", "temp", null, "qcs_output_correct_RESOURCE_ID.csv", "DataRecordDAOImpl"),
    DATA_RECORD_VALID("The file where valid records are saved", "temp", null, "qcs_output_valid_RESOURCE_ID.csv", "DataRecordDAOImpl"),
    DATA_RECORD_WITH_ISSUES("The file where invalid records are saved", "temp", null, "qcs_output_with_issues_RESOURCE_ID.csv", "DataRecordDAOImpl"),
    DATA_RECORD_UNCHECKED("The file where unchecked records are saved", "temp", null, "qcs_output_blocking_RESOURCE_ID.csv", "DataRecordDAOImpl"),
    VALIDATION_RUN("List of all performed validation runs", "temp", null, "validation_run.csv", "ValidationRunDAOImpl"),
    RULE_OUTPUT("List of errors/warnings in one validation run", "temp", null, "qcs_rule_output_RESOURCE_ID.csv", "RuleOutputDAOImpl"),
    RULE_OUTPUT_DETAIL("Details of errors/warnings in one validation run", "temp", null, "qcs_rule_output_detail_RESOURCE_ID.csv", "RuleOutputDetailDAOImpl"),
    REFERENCE_FIELD("Configuration of the reports' \"registry fields\"", "configuration/protocol", null, "reference_field.csv", "ReferenceFieldDAOImpl");

    public final String description;
    public final String path;
    public final String folder;
    public final String name;
    public final String dao;
    public static final String DAO_PACKAGE = "eu.europa.ec.jrc.qcs.dao.file";
    public static final String INTERNAL_CONFIG_PATH = "configuration";
    public static final String EXTERNAL_CONFIG_PATH = "config";
    public static final String RULES_BASE_PATH = "config/rules";
    private static final String SCHEMAS_PATH = "configuration/schema";
    private static final String RULES_PATH = "configuration/protocol";
    public static final String TEMP_PATH = "temp";
    public static final String OUTPUT_PATH = "output";

    private FlatFile(String description, String path, String folder, String name, String dao) {
        this.description = description;
        this.path = path;
        this.folder = folder;
        this.name = name;
        this.dao = dao;
    }

    public boolean isDynamic() {
        return this.hasDynamicName() || this.hasDynamicFolder();
    }

    public boolean hasDynamicName() {
        if (this.name == null) {
            return false;
        }
        return this.name.contains("RESOURCE_ID");
    }

    public boolean hasDynamicFolder() {
        if (this.folder == null) {
            return false;
        }
        return this.folder.contains("SUB_DIRECTORY");
    }

    public boolean inClassPath() {
        if (this.path == null) {
            return false;
        }
        return this.path != TEMP_PATH;
    }

    public String getInternalPath() {
        return INTERNAL_CONFIG_PATH + this.path;
    }

    public String getExternalPath() {
        return EXTERNAL_CONFIG_PATH + this.path;
    }

    public boolean isTemporaryFile() {
        return this.path == TEMP_PATH && this != VALIDATION_RUN;
    }

    public static String getRelativePath(FlatFile flatFile, int resourceID) {
        String abstractName = flatFile.path + "/" + flatFile.name;
        String concreteName = abstractName.replaceAll("RESOURCE_ID", String.valueOf(resourceID));
        return concreteName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("=");
        builder.append(this.path);
        if (this.folder != null) {
            builder.append("/");
            builder.append(this.folder);
        }
        builder.append("/");
        builder.append(this.name);
        return builder.toString();
    }

    public class Token {
        public static final String SUB_DIR = "SUB_DIRECTORY";
        public static final String RESOURCE_ID = "RESOURCE_ID";
    }
}

