/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConnection
extends LocalFile
implements DataConnection {
    protected FlatFile flatFile;
    protected LocalFile localFile;
    protected InputStream inputStream;
    protected FileWriter fileWriter;
    protected boolean append = true;
    protected boolean temporary = false;
    protected boolean verbose = false;
    protected static String classLoaderAbsolutePath;
    protected static Logger logger;

    public FileConnection(FlatFile flatFile) {
        this(flatFile.name, flatFile.path);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating instance from FlatFile : " + String.valueOf((Object)flatFile));
            logger.debug("FlatFile path : " + flatFile.path + " -> " + flatFile.name);
        }
        this.flatFile = flatFile;
        if (flatFile.name != null) {
            // empty if block
        }
    }

    public FileConnection(LocalFile localFile) {
        super(localFile);
        this.localFile = localFile;
    }

    public FileConnection(String fileName, String relativePath) {
        super(fileName, relativePath);
    }

    public FileConnection(FileConnection otherConnection) {
        this(otherConnection.flatFile);
    }

    public FileConnection() {
    }

    public FileConnection(String absolutePath) {
        super(absolutePath);
    }

    @Override
    public void openConnection() {
        if (this.verbose) {
            String readStatus = "Read access: " + this.hasReadAccess() + " [" + String.valueOf(this.inputStream) + "]";
            String writeStatus = "Write access: " + this.hasWriteAccess() + " [" + String.valueOf(this.fileWriter) + "]";
            logger.info("");
            logger.info("openConnection() - TARGET_RESOURCE: " + this.fileName);
            logger.info("openConnection() - " + readStatus + " / " + writeStatus);
        }
        if (this.hasReadAccess() && this.inputStream == null) {
            if (this.verbose) {
                logger.info("openConnection() - Opening inputStream");
            }
            if (this.getAbsolutePath() != null) {
                if (this.verbose) {
                    logger.info("openConnection() - Open inputStream from absolute path = " + this.getAbsolutePath() + " -> " + this.fileName);
                }
                this.openStreamFromAbsolutePath();
            } else if (this.getRelativePath() != null) {
                if (this.verbose) {
                    logger.info("openConnection() - Open inputStream from relative path = " + this.getRelativePath() + " -> " + this.fileName);
                }
                this.openStreamFromRelativePath(this.fileName);
            }
            if (this.inputStream != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("openConnection() - Opened inputStream: " + String.valueOf(this.inputStream) + " for resource: " + this.getFileName());
                }
            } else if (!this.isTemporaryFile()) {
                logger.warn("openConnection() - Failed opening inputStream for resource: " + this.getFileName());
            } else if (logger.isDebugEnabled()) {
                logger.debug("openConnection() - Failed opening inputStream for resource: " + this.getFileName());
            }
        }
        if (this.hasWriteAccess() && this.fileWriter == null) {
            if (this.verbose) {
                logger.info("openConnection() - Opening fileWriter");
            }
            if (this.getAbsolutePath() != null) {
                if (this.verbose) {
                    logger.info("openConnection() - Open fileWriter from absolute path = " + this.getAbsolutePath() + " -> " + this.fileName);
                }
                this.openWriterFromAbsolutePath();
            } else if (this.getRelativePath() != null) {
                if (this.verbose) {
                    logger.info("openConnection() - Open fileWriter from relative path = " + this.getRelativePath() + " -> " + this.fileName);
                }
                this.openWriterFromRelativePath();
            }
            if (this.fileWriter != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("openConnection() - Opened fileWriter: " + String.valueOf(this.fileWriter) + " (" + this.getFileName() + ")");
                }
            } else {
                logger.warn("openConnection() - Failed opening fileWriter for resource: " + this.getFileName());
            }
        }
    }

    @Override
    public void closeConnection() {
        if (this.hasReadAccess()) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                    if (logger.isTraceEnabled()) {
                        logger.trace("closeConnection() - CLOSED InputStream for resource: " + this.getFileName());
                    }
                }
            }
            catch (IOException e) {
                logger.error("closeConnection() - Failed to close IO input stream for file: " + this.getFileName());
            }
            catch (Exception e) {
                logger.error("closeConnection() - Failed to close input stream for file: " + this.getFileName());
            }
        }
        if (this.hasWriteAccess()) {
            try {
                if (this.fileWriter != null) {
                    this.fileWriter.close();
                    this.fileWriter = null;
                    if (logger.isTraceEnabled()) {
                        logger.trace("closeConnection() - CLOSED FileWriter for resource: " + this.getFileName());
                    }
                }
            }
            catch (IOException e) {
                logger.error("closeConnection() - Failed to close IO output stream for file: " + this.getFileName());
            }
            catch (Exception e) {
                logger.error("closeConnection() - Failed to close output stream for file: " + this.getFileName());
            }
        }
    }

    protected void openStreamFromAbsolutePath() {
        this.inputStream = null;
        try {
            this.inputStream = new FileInputStream(this.absolutePath);
        }
        catch (FileNotFoundException e) {
            if (this.isTemporaryFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("openStreamFromAbsolutePath() - Failed to open input stream from absolute path: " + this.absolutePath);
                }
            }
            logger.warn("openStreamFromAbsolutePath() - Failed to open input stream from absolute path: " + this.absolutePath);
        }
        if (this.inputStream == null) {
            if (this.isTemporaryFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("openStreamFromAbsolutePath() - Failed to load file " + this.absolutePath + ": null input stream");
                }
            } else {
                logger.warn("openStreamFromAbsolutePath() - Failed to load file " + this.absolutePath + ": null input stream");
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("openStreamFromAbsolutePath() - Loading file: " + this.absolutePath + " [" + String.valueOf(this.inputStream) + "]");
        }
    }

    protected void openStreamFromRelativePath(String targetName) {
        if (this.verbose) {
            logger.info("openStreamFromRelativePath() - 1. Looking for resource in the EXTERNAL path (config)        - Target name: " + targetName);
        }
        this.lookUpInputStream(targetName);
        if (this.inputStream == null) {
            if (this.verbose) {
                logger.warn("openStreamFromRelativePath() - 1.1 Resource not_found in the EXTERNAL path                  - Target name: " + targetName);
            }
        } else {
            if (this.verbose) {
                logger.info("openStreamFromRelativePath() - 1.2 Opened stream from EXTERNAL path                         - Target name: " + targetName + " -> " + String.valueOf(this.inputStream));
            }
            return;
        }
        if (this.verbose) {
            logger.info("openStreamFromRelativePath() - 2. Looking for resource in the INTERNAL path (configuration) - Target name: " + targetName);
        }
        String innerPath = this.getRelativePath() + "/" + targetName;
        this.lookUpInputStream(innerPath);
        if (this.inputStream == null) {
            if (this.verbose) {
                logger.warn("openStreamFromRelativePath() - 2.1 Resouce not_found in the INTERNAL path                   - Target name: " + targetName);
            }
        } else if (this.verbose) {
            logger.info("openStreamFromRelativePath() - 2.2 Opened stream from INTERNAL path                         - Target name: " + targetName + " -> " + String.valueOf(this.inputStream));
        }
        if (this.inputStream == null && !this.isInClassPath()) {
            if (this.verbose) {
                logger.info("openStreamFromRelativePath() - 3. Looking for resource not in classpath.                    - Target name: " + targetName);
            }
            String userDir = System.getProperty("user.dir");
            this.setAbsolutePath(userDir + "/" + innerPath);
            if (this.verbose) {
                logger.info("openStreamFromRelativePath() - 3.1 Trying with absolute path        : " + this.absolutePath);
            }
            this.openStreamFromAbsolutePath();
        }
        if (this.inputStream == null) {
            if (this.verbose) {
                logger.warn("openStreamFromRelativePath() - 4.1 Resouce not_found -> relativePath: " + this.relativePath + " -> innerPath: " + innerPath + " (absolute path: " + this.absolutePath + ")");
            }
        } else if (this.verbose) {
            logger.info("openStreamFromRelativePath() - 4.2 Opened stream -> relativePath: " + this.relativePath + " -> innerPath: " + innerPath + " (absolute path: " + this.absolutePath + ")");
        }
    }

    protected InputStream lookUpInputStream(String resourcePath) {
        if (logger.isTraceEnabled()) {
            logger.trace("lookUpInputStream() - resourcePath = " + resourcePath);
        }
        try {
            this.inputStream = this.getClass().getResourceAsStream("/" + resourcePath);
        }
        catch (Exception e) {
            logger.warn("lookUpInputStream() - Failed to load class based input stream for file: " + resourcePath);
        }
        if (this.inputStream != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("lookUpInputStream() - Found class based input stream for file: " + resourcePath + " [" + String.valueOf(this.inputStream) + "]");
            }
            return this.inputStream;
        }
        try {
            this.inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        }
        catch (Exception e) {
            logger.warn("lookUpInputStream() - Failed to load class-loader based input stream for file: " + resourcePath);
        }
        if (this.inputStream != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("lookUpInputStream() - Found class-loader based input stream for file: " + resourcePath + " [" + String.valueOf(this.inputStream) + "]");
            }
            return this.inputStream;
        }
        try {
            this.inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        }
        catch (Exception e) {
            logger.warn("lookUpInputStream() - Failed to load thread based input stream for file: " + resourcePath);
        }
        if (this.inputStream != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("lookUpInputStream() - Found thread based input stream for file: " + resourcePath + " [" + String.valueOf(this.inputStream) + "]");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("lookUpInputStream() - Failed to load input stream for file: " + resourcePath);
        }
        return this.inputStream;
    }

    public void openWriterFromRelativePath() {
        if (this.verbose) {
            logger.info("openWriterFromRelativePath() - 1. Opening resource in the EXTERNAL path (config)        - Target name: " + this.fileName);
        }
        String absoluteClassesPath = this.getClassesAbsolutePath();
        this.absolutePath = absoluteClassesPath + this.getExternalRelativePath() + "/" + this.fileName;
        if (this.verbose) {
            logger.info("openWriterFromRelativePath() - 1.1 Converted EXTERNAL relative path to absolute path                 : " + this.absolutePath);
        }
        this.openWriterFromAbsolutePath();
        if (this.fileWriter == null) {
            if (this.verbose) {
                logger.warn("openWriterFromRelativePath() - 1.2 Resource not_opened in the EXTERNAL configuration    - Target name: " + this.fileName);
            }
        } else {
            if (this.verbose) {
                logger.info("openWriterFromRelativePath() - 1.3 Opened writer from EXTERNAL configuration            - Target name: " + this.fileName + " -> " + String.valueOf(this.fileWriter));
            }
            return;
        }
        if (this.verbose) {
            logger.info("openWriterFromRelativePath() - 2. Opening resource in the INTERNAL path (configuration) - Target name: " + this.fileName);
        }
        this.absolutePath = absoluteClassesPath + this.getRelativePath() + "/" + this.fileName;
        if (this.verbose) {
            logger.info("openWriterFromRelativePath() - 2.1 Converted INTERNAL relative path to absolute path                 : " + this.absolutePath);
        }
        this.openWriterFromAbsolutePath();
        if (this.fileWriter == null) {
            if (this.verbose) {
                logger.warn("openWriterFromRelativePath() - 2.2 Resource not_opened in the INTERNAL configuration    - Target name: " + this.fileName);
            }
        } else {
            if (this.verbose) {
                logger.info("openWriterFromRelativePath() - 2.3 Opened writer from INTERNAL configuration            - Target name: " + this.fileName + " -> " + String.valueOf(this.fileWriter));
            }
            return;
        }
    }

    public void openWriterFromAbsolutePath() {
        if (logger.isTraceEnabled()) {
            logger.trace("openWriterFromAbsolutePath() - Open fileWriter from absolute path = " + this.absolutePath);
        }
        if (this.absolutePath.contains("%20")) {
            if (logger.isInfoEnabled()) {
                logger.info("openWriterFromAbsolutePath() - Replacing \"blank char\" in absolute path = " + this.absolutePath);
            }
            this.absolutePath = this.absolutePath.replaceAll("%20", " ");
        }
        try {
            this.fileWriter = new FileWriter(this.absolutePath, this.append);
        }
        catch (IOException e) {
            if (this.checkInternalConfiguration(this.absolutePath)) {
                logger.warn("openWriterFromAbsolutePath() - Resource not found in absolute path " + this.absolutePath);
            }
            logger.error("openWriterFromAbsolutePath() - Error opening connection to absolute path " + this.absolutePath + " : " + e.getMessage());
        }
        if (logger.isTraceEnabled()) {
            if (this.fileWriter != null) {
                logger.trace("openWriterFromAbsolutePath - Opened writer form absolutePath: " + this.absolutePath + " -> " + String.valueOf(this.fileWriter));
            } else {
                logger.trace("openWriterFromAbsolutePath - Failed opening writer form absolutePath: " + this.absolutePath + " -> " + String.valueOf(this.fileWriter));
            }
        }
    }

    protected boolean isInClassPath() {
        if (this.flatFile == null) {
            return false;
        }
        return this.flatFile.inClassPath();
    }

    protected String getExternalRelativePath() {
        String internalRelativePath = new String(this.relativePath);
        String externalRelativePath = internalRelativePath.replace("configuration", "config");
        return externalRelativePath;
    }

    protected String getLocationInClasspath() {
        String classesPath = this.getClassesAbsolutePath();
        String path = classesPath.contains("classes") ? classesPath + "configuration" : classesPath + "config";
        File file = new File(path);
        String absolutePath = file.getAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug("getLocationInClasspath() : absolutePath = " + absolutePath);
        }
        return absolutePath;
    }

    protected String getClassesAbsolutePath() {
        URL location = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String urlPath = location.getFile();
        if (logger.isDebugEnabled()) {
            logger.debug("getClassesAbsolutePath() : urlPath      = " + urlPath);
        }
        String classesPath = null;
        if (urlPath.contains("classes")) {
            classesPath = urlPath;
        } else {
            String[] tokens = urlPath.split("/");
            String jarName = tokens[tokens.length - 1];
            classesPath = urlPath.replace(jarName, "");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getClassesAbsolutePath() : classesPath  = " + classesPath);
        }
        return classesPath;
    }

    protected boolean checkInternalConfiguration(String externalPath) {
        Path path;
        if (logger.isTraceEnabled()) {
            logger.trace("checkInternalConfiguration() - Checking absolute path: " + externalPath);
        }
        if (externalPath.charAt(2) == ':') {
            externalPath = externalPath.substring(3, externalPath.length());
        }
        if (externalPath.contains("\\")) {
            externalPath.replace("\\", "\\/");
        }
        int lastSlashIndex = externalPath.lastIndexOf(47);
        String basePath = externalPath.substring(0, lastSlashIndex);
        if (logger.isTraceEnabled()) {
            logger.trace("checkInternalConfiguration() - Produced basePath: " + basePath);
        }
        try {
            String internalPath = basePath.replace("config", "configuration");
            path = Paths.get(internalPath, new String[0]);
        }
        catch (Exception e) {
            logger.error("checkInternalConfiguration() - Wrong path syntax: " + externalPath);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("checkInternalConfiguration() - Checking path: " + String.valueOf(path));
        }
        return Files.exists(path, new LinkOption[0]);
    }

    protected String getClassLoaderAbsolutePath() {
        if (classLoaderAbsolutePath != null) {
            return classLoaderAbsolutePath;
        }
        String mainPropertiesFile = FlatFile.PROPERTIES.path + "/" + FlatFile.PROPERTIES.name;
        URL resourcePath = this.getClass().getClassLoader().getResource(mainPropertiesFile);
        if (logger.isDebugEnabled()) {
            logger.debug("getClassLoaderAbsolutePath() - resourcePath = " + String.valueOf(resourcePath));
        }
        File file = null;
        try {
            file = Paths.get(resourcePath.toURI()).toFile();
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            if (logger.isDebugEnabled()) {
                logger.debug("getClassLoaderAbsolutePath() - absolutePath : " + absolutePath);
            }
            classLoaderAbsolutePath = this.getResourceBasePath(absolutePath, "classes");
        } else {
            String fullPath = resourcePath.toString();
            int resourceSeparatorIndex = fullPath.indexOf(33);
            String jarFilePath = fullPath.substring(0, resourceSeparatorIndex);
            String jarPath = jarFilePath.replace("jar:file:/", "");
            if (logger.isDebugEnabled()) {
                logger.debug("getClassLoaderAbsolutePath() - jarPath : " + jarPath);
            }
            classLoaderAbsolutePath = this.getResourceBasePath(jarPath, "distro");
        }
        if (logger.isInfoEnabled()) {
            logger.info("getClassLoaderAbsolutePath() - classes absolute path : " + classLoaderAbsolutePath);
        }
        return classLoaderAbsolutePath;
    }

    private String getResourceBasePath(String path, String key) {
        if (logger.isTraceEnabled()) {
            logger.trace("getResourceBasePath() - Parsing path " + path + " until \"" + key + "\" token");
        }
        StringTokenizer tokenizer = path.contains("\\") ? new StringTokenizer(path, "\\") : new StringTokenizer(path, "/");
        StringBuilder result = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result.append(token);
            if (token.equals(key)) break;
            result.append("/");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getResourceBasePath() - Found base path: " + String.valueOf(result));
        }
        return result.toString();
    }

    public boolean hasInputStream() {
        return this.inputStream != null;
    }

    public boolean hasFileWriter() {
        return this.fileWriter != null;
    }

    public boolean isTemporaryFile() {
        if (this.flatFile == null) {
            return this.isTemporary();
        }
        return this.flatFile.isTemporaryFile();
    }

    private boolean isTemporary() {
        return this.temporary;
    }

    public FlatFile getFlatFile() {
        return this.flatFile;
    }

    public void setFlatFile(FlatFile flatFile) {
        this.flatFile = flatFile;
    }

    public LocalFile getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(LocalFile localFile) {
        this.localFile = localFile;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setFileWriter(FileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public boolean validate() {
        return this.fileName != null || this.absolutePath != null || this.relativePath != null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append("fileName=");
        builder.append(this.fileName);
        builder.append(", abs=");
        builder.append(this.absolutePath);
        builder.append(", rel=");
        builder.append(this.relativePath);
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(FileConnection.class);
    }
}

