/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.model.config.ApplicationProperties;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFileConnection
extends FileConnection {
    protected String lastDynamicName;
    protected static Map<String, HashSet<String>> dynamicDirectories = new HashMap<String, HashSet<String>>();
    protected static int maxFolderID;
    protected static Logger logger;

    public DynamicFileConnection(FlatFile flatFile) {
        super(flatFile);
        if (logger.isDebugEnabled()) {
            logger.debug("Created with maxFolderID = " + maxFolderID);
        }
    }

    public boolean openStreamFromDynamicPath(int resourceID) {
        if (resourceID < 0) {
            String message = "Negative resourceID for file " + this.getFileName() + " : " + resourceID;
            logger.warn(message);
            return false;
        }
        boolean verbose = false;
        String candidateName = this.getActualFileName(resourceID);
        if (verbose) {
            logger.info("openStreamFromDynamicPath() - Candidate dynamic file name  : " + this.fileName + " [ID:" + resourceID + "] -> " + candidateName);
            logger.info("openStreamFromDynamicPath() - Current absolute path        : " + this.getAbsolutePath());
        }
        if (this.flatFile.hasDynamicFolder()) {
            if (verbose) {
                logger.info("openStreamFromDynamicPath() - Opening from classpath       : " + candidateName);
            }
            this.openStreamFromClassPath(candidateName);
        } else {
            if (verbose) {
                logger.info("openStreamFromDynamicPath() - Using static sub-folder for resource: " + candidateName);
            }
            this.lookUpStream(candidateName);
        }
        if (verbose) {
            logger.info("openStreamFromDynamicPath() - Final dynamic file name      : " + this.fileName + " [ID:" + resourceID + "] -> " + candidateName);
            logger.info("openStreamFromDynamicPath() - Final absolute path          : " + this.getAbsolutePath());
            logger.info("openStreamFromDynamicPath() - Opened InputStream           : " + String.valueOf(this.inputStream));
        }
        if (this.inputStream == null) {
            if (this.isTemporaryFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("openStreamFromDynamicPath() - Dynamic file not found " + this.flatFile.folder + "/" + this.fileName + " for resource ID = " + resourceID);
                }
            } else {
                logger.error("openStreamFromDynamicPath() - Dynamic file not found " + this.flatFile.folder + "/" + this.fileName + " for resource ID = " + resourceID);
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("openStreamFromDynamicPath() - InputStream: " + String.valueOf(this.inputStream) + " (" + this.getFileName() + ")");
        }
        return true;
    }

    protected void openStreamFromFileSystem(String candidateName) {
        HashSet<String> subDirectories;
        boolean someSubDirectoriesAreMissing;
        File[] filesList;
        block13: {
            String parentDirectory = this.flatFile.path;
            File directory = new File(this.getClassLoaderAbsolutePath() + "/" + parentDirectory);
            filesList = directory.listFiles();
            if (logger.isDebugEnabled()) {
                logger.debug("openStreamFromFileSystem() - Directory : " + String.valueOf(directory));
            }
            someSubDirectoriesAreMissing = false;
            subDirectories = dynamicDirectories.get(parentDirectory);
            try {
                if (subDirectories == null) {
                    someSubDirectoriesAreMissing = true;
                    subDirectories = new HashSet();
                    dynamicDirectories.put(parentDirectory, subDirectories);
                } else {
                    int expectedSubDirectories = filesList.length - 2;
                    boolean bl = someSubDirectoriesAreMissing = subDirectories.size() < expectedSubDirectories;
                    if (someSubDirectoriesAreMissing && logger.isDebugEnabled()) {
                        logger.debug("openStreamFromFileSystem() - Updating dynamic sub directories list: " + subDirectories.size() + " < " + expectedSubDirectories);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block13;
                logger.debug("openStreamFromFileSystem() - Missing sub directory feature: not applicable when running from JAR");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("openStreamFromFileSystem() - Parent directory : " + this.flatFile.path + " (empty = " + someSubDirectoriesAreMissing + ")");
        }
        if (filesList != null) {
            for (File file : filesList) {
                if (file.isDirectory()) {
                    String subDirName = this.getLastPathToken(file.getAbsolutePath());
                    String candidatePath = subDirName + "/" + candidateName;
                    if (logger.isDebugEnabled()) {
                        logger.debug("openStreamFromFileSystem() - CandidatePath : " + candidatePath);
                    }
                    if (someSubDirectoriesAreMissing) {
                        subDirectories.add(subDirName);
                    }
                    if (!this.lookUpStream(candidatePath)) continue;
                    break;
                }
                logger.warn("openStreamFromFileSystem() - Skipping not directory resource: " + String.valueOf(file));
            }
        } else {
            logger.warn("openStreamFromFileSystem() - Found null file list");
        }
    }

    protected void openStreamFromClassPath(String candidateName) {
        if (maxFolderID <= 0) {
            throw new IllegalStateException("openStreamFromClassPath() - MaxFolderID not set: check application.properties file");
        }
        for (int i = 1; i <= maxFolderID; ++i) {
            String candidatePath = i + "/" + candidateName;
            if (logger.isTraceEnabled()) {
                logger.trace("openStreamFromClassPath() - Looking up path: " + candidatePath);
            }
            if (this.lookUpStream(candidatePath)) break;
        }
    }

    protected boolean lookUpStream(String path) {
        this.openStreamFromRelativePath(path);
        if (logger.isTraceEnabled()) {
            logger.trace("lookUpStream() - Checked existence of stream for dynamic resource: " + path + " -> " + String.valueOf(this.inputStream));
        }
        if (this.inputStream != null) {
            this.setLastDynamicPath(path);
            if (logger.isTraceEnabled()) {
                logger.trace("lookUpStream() - Found valid dynamic resource's name: " + this.getLastDynamicName());
            }
            return true;
        }
        return false;
    }

    public void openWriterFromDynamicPath(int folderID, int resourceID) {
        if (resourceID < 0) {
            return;
        }
        boolean verbose = false;
        String candidateName = this.getActualFileName(resourceID);
        if (verbose) {
            logger.info("openWriterFromDynamicPath() - Candidate dynamic file name : " + this.fileName + " [ID:" + resourceID + "] -> " + candidateName);
            logger.info("openWriterFromDynamicPath() - Current absolute path       : " + this.getAbsolutePath());
        }
        if (!this.flatFile.inClassPath()) {
            String userDir = System.getProperty("user.dir");
            String innerPath = this.getRelativePath() + "/" + candidateName;
            this.setAbsolutePath(userDir + "/" + innerPath);
            if (verbose) {
                logger.info("openWriterFromDynamicPath() - New absolute path           : " + this.getAbsolutePath());
            }
        } else {
            String targetPath = this.getClassesAbsolutePath() + this.flatFile.path + "/" + folderID + "/" + candidateName;
            this.setAbsolutePath(targetPath);
            if (verbose) {
                logger.info("openWriterFromDynamicPath() - New absolute path           : " + targetPath);
            }
        }
        if (this.getAbsolutePath() != null) {
            this.openWriterFromAbsolutePath();
        }
        if (this.fileWriter == null) {
            logger.error("openWriterFromDynamicPath() - Dynamic file not found " + this.flatFile.folder + "/" + this.fileName + " for resource ID = " + resourceID);
        } else if (logger.isDebugEnabled()) {
            logger.debug("openWriterFromDynamicPath() - FileWriter: " + String.valueOf(this.fileWriter) + " (" + this.getFileName() + ")");
        }
    }

    protected String getLastPathToken(String path) {
        String directoryName = null;
        StringTokenizer tokenizer = null;
        tokenizer = path.contains("\\") ? new StringTokenizer(path, "\\") : new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            directoryName = tokenizer.nextToken();
        }
        return directoryName;
    }

    protected String getActualFileName(int resourceID) {
        String candidateName = new String(this.fileName);
        if (this.flatFile.hasDynamicName()) {
            String token = String.valueOf(resourceID);
            String placeholder = "RESOURCE_ID";
            candidateName = this.fileName.replaceAll(placeholder, token);
            if (logger.isTraceEnabled()) {
                logger.trace("getActualFileName() - Produced dynamic file name: " + this.fileName + " [ID:" + resourceID + "] -> " + candidateName);
            }
        }
        return candidateName;
    }

    public void setLastDynamicPath(String fileName) {
        String filePath;
        this.lastDynamicName = filePath = new String(fileName);
    }

    public String getLastDynamicName() {
        return this.lastDynamicName;
    }

    public static Map<String, HashSet<String>> getDynamicDirectories() {
        return dynamicDirectories;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("file=");
        builder.append(this.getFileName());
        builder.append(", abs=");
        builder.append(this.getAbsolutePath());
        builder.append(", stream=");
        builder.append(this.getInputStream());
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = LoggerFactory.getLogger(DynamicFileConnection.class);
        Configuration configuration = Configuration.getInstance();
        ApplicationProperties applicationProperties = configuration.getApplicationProperties();
        String maxFolderIDAsString = applicationProperties.getValue(Property.MAX_GROUP_ID);
        try {
            maxFolderID = Integer.parseInt(maxFolderIDAsString);
        }
        catch (NumberFormatException e) {
            maxFolderID = 4;
            logger.warn("Loaded hard-coded value for maxFolderID = " + maxFolderID + " (wrong value: " + maxFolderIDAsString + ")");
        }
    }
}

