/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.DataRecordDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.RuleOutputDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.RuleOutputDetailDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.ValidationRunDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.handler.FallbackHandler;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import eu.europa.ec.jrc.qcs.dao.jpa.FieldRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.MetadataRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ProtocolRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ProtocolToRuleRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ProtocolViewRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.RangeDataRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.RangeRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ReferenceFieldRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.RuleDefinitionRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.RuleToFieldRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaGroupRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaToFieldRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.SchemaViewRepository;
import eu.europa.ec.jrc.qcs.dao.jpa.ValidationMessageRepository;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDAOFactory
extends DAOFactory {
    private EntityManager entityManager;
    public static final String DB_FILE_NAME = "qcs.db";
    public static final String DB_FACTORY_HASH = "b359d90ba6bd2590170ddfbb58d801b1c2d685ed947392739c0c14af93c43a08";
    protected static Logger logger = LoggerFactory.getLogger(DatabaseDAOFactory.class);

    private DatabaseDAOFactory() {
        this.cached = true;
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"local_dev");
        this.entityManager = entityManagerFactory.createEntityManager();
        if (logger.isInfoEnabled()) {
            logger.info("Constructor() - Created entity manager: " + String.valueOf(this.entityManager));
        }
    }

    public static DatabaseDAOFactory getInstance() {
        DatabaseDAOFactory daoFactory = DAOFactorySingleton.SINGLETON.get();
        if (logger.isTraceEnabled()) {
            logger.trace("getInstance() - Retrieved DAO factory singleton: " + String.valueOf(daoFactory));
        }
        return daoFactory;
    }

    public static boolean init() {
        String[] lines;
        String persistenceFileName = "persistence.xml";
        String persistencePath = "META-INF/" + persistenceFileName;
        InputStream inputStream = DatabaseDAOFactory.class.getClassLoader().getResourceAsStream(persistencePath);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - InputStream " + String.valueOf(inputStream));
        }
        if (inputStream == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("init() - " + persistenceFileName + " not in classpath -> trying to look in the JAR");
            }
            if ((inputStream = DatabaseDAOFactory.class.getResourceAsStream(persistencePath)) == null) {
                logger.error("init() - " + persistenceFileName + " not found in the JAR");
                return false;
            }
            if (logger.isInfoEnabled()) {
                logger.info("init() - " + persistenceFileName + " found in JAR");
            }
        } else if (logger.isDebugEnabled()) {
            logger.info("init() - " + persistenceFileName + " not found in classpath !!!");
        }
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                fileContent.append((char)c);
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("init() - Error loading persistence configuration: " + e.getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - File's content: " + fileContent.toString());
        }
        String dbFileName = "";
        for (String s : lines = fileContent.toString().split("\\n")) {
            if (logger.isTraceEnabled()) {
                logger.trace("init() - Content : " + s + " (" + s.length() + ")");
            }
            if (!s.contains("jdbc:sqlite:")) continue;
            Integer begin = s.lastIndexOf(":");
            Integer end = s.lastIndexOf("\"");
            dbFileName = s.substring(begin + 1, end);
            break;
        }
        if (logger.isInfoEnabled()) {
            logger.info("init() - Looking for database's file: " + dbFileName);
        }
        FallbackHandler fallbackHandler = new FallbackHandler();
        fallbackHandler.manageFallback(dbFileName);
        DatabaseDAOFactory thisSingleton = DatabaseDAOFactory.getInstance();
        ProtocolViewRepository protocolViewRepository = (ProtocolViewRepository)thisSingleton.getDAO(DAO.PROTOCOL_VIEW);
        ProtocolView protocolView = protocolViewRepository.getByID(DefaultProtocolID.INCIDENCE_2020.id);
        if (protocolView == null || protocolView == ProtocolView.UNDEF) {
            String message = "Working database looks empty. Please check fallback configuration";
            logger.error("init() - " + message);
            throw new IllegalStateException(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info("init() - Initialization succesfull");
        }
        return true;
    }

    @Override
    public GenericHandler<?> getDAO(DAO dao) {
        GenericHandler daoObject = null;
        if (this.cached && (daoObject = (GenericHandler)this.daoMAP.get((Object)dao)) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("getDAO() - Cache hit -> returning existing dao: " + String.valueOf(daoObject));
            }
            return daoObject;
        }
        daoObject = this.getConcretedDAO(dao);
        if (this.cached) {
            this.daoMAP.put(dao, daoObject);
            if (logger.isDebugEnabled()) {
                logger.debug("getDAO() - Cache miss -> cached new dao: " + String.valueOf(daoObject));
            }
        }
        return daoObject;
    }

    protected GenericHandler<?> getConcretedDAO(DAO dao) {
        if (DAO.SCHEMA == dao) {
            return new SchemaRepository(this.entityManager);
        }
        if (DAO.SCHEMAS_GROUP == dao) {
            return new SchemaGroupRepository(this.entityManager);
        }
        if (DAO.FIELD == dao) {
            return new FieldRepository(this.entityManager);
        }
        if (DAO.RANGE == dao) {
            return new RangeRepository(this.entityManager);
        }
        if (DAO.RANGE_DATA == dao) {
            return new RangeDataRepository(this.entityManager);
        }
        if (DAO.SCHEMA_TO_FIELD == dao) {
            return new SchemaToFieldRepository(this.entityManager);
        }
        if (DAO.SCHEMA_VIEW == dao) {
            return new SchemaViewRepository();
        }
        if (DAO.RULE_DEFINITION == dao) {
            return new RuleDefinitionRepository(this.entityManager);
        }
        if (DAO.PROTOCOL == dao) {
            return new ProtocolRepository(this.entityManager);
        }
        if (DAO.PROTOCOL_TO_RULE == dao) {
            return new ProtocolToRuleRepository(this.entityManager);
        }
        if (DAO.RULE_TO_FIELD == dao) {
            return new RuleToFieldRepository(this.entityManager);
        }
        if (DAO.VALIDATION_MESSAGE == dao) {
            return new ValidationMessageRepository(this.entityManager);
        }
        if (DAO.PROTOCOL_VIEW == dao) {
            return new ProtocolViewRepository();
        }
        if (DAO.DATA_RECORD == dao) {
            return new DataRecordDAOImpl();
        }
        if (DAO.DATA_RECORD_CORRECT == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.DATA_RECORD_CORRECT);
            return new DataRecordDAOImpl(connection);
        }
        if (DAO.DATA_RECORD_VALID == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.DATA_RECORD_VALID);
            return new DataRecordDAOImpl(connection);
        }
        if (DAO.DATA_RECORD_WITH_ISSUES == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.DATA_RECORD_WITH_ISSUES);
            return new DataRecordDAOImpl(connection);
        }
        if (DAO.DATA_RECORD_UNCHECKED == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.DATA_RECORD_UNCHECKED);
            return new DataRecordDAOImpl(connection);
        }
        if (DAO.VALIDATION_RUN == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.VALIDATION_RUN);
            return new ValidationRunDAOImpl(connection);
        }
        if (DAO.RULE_OUTPUT == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.RULE_OUTPUT);
            return new RuleOutputDAOImpl(connection);
        }
        if (DAO.RULE_OUTPUT_DETAIL == dao) {
            FileConnection connection = FlatFileDAOFactory.getConnection(DAO.RULE_OUTPUT_DETAIL);
            return new RuleOutputDetailDAOImpl(connection);
        }
        if (DAO.REFERENCE_FIELD == dao) {
            return new ReferenceFieldRepository(this.entityManager);
        }
        if (DAO.METADATA == dao) {
            return new MetadataRepository(this.entityManager);
        }
        return null;
    }

    public void close() {
        EntityManagerFactory emf = null;
        if (this.entityManager != null && this.entityManager.isOpen()) {
            try {
                emf = this.entityManager.getEntityManagerFactory();
            }
            catch (IllegalStateException e) {
                logger.warn("close() - Failed to retrieve EntityManagerFactory: " + e.getMessage());
            }
            this.entityManager.close();
        }
        if (emf != null && emf.isOpen()) {
            emf.close();
        }
        if (logger.isInfoEnabled()) {
            logger.info("close() - Closed entity manager factory");
        }
    }

    private static class DAOFactorySingleton {
        public static ThreadLocal<DatabaseDAOFactory> SINGLETON;
        protected static Logger logger;

        private DAOFactorySingleton() {
        }

        static {
            logger = LoggerFactory.getLogger(DAOFactorySingleton.class);
            ThreadLocal<DatabaseDAOFactory> daoFactory = null;
            String thread = Thread.currentThread().getName();
            if (logger.isDebugEnabled()) {
                logger.debug("static - Creating DAOFactorySingleton instance (static thread local) for thread: " + thread);
            }
            try {
                daoFactory = new ThreadLocal<DatabaseDAOFactory>(){

                    @Override
                    protected DatabaseDAOFactory initialValue() {
                        try {
                            if (logger.isInfoEnabled()) {
                                String thread = Thread.currentThread().getName();
                                logger.info("initialValue() - Creating DAOFactory singleton for thread: " + thread);
                            }
                            return new DatabaseDAOFactory();
                        }
                        catch (Exception e) {
                            logger.error("initialValue() - Failed creation of the singleton: " + e.getMessage());
                            return null;
                        }
                        catch (Throwable t) {
                            logger.error("initialValue() - Fatal error creating singleton: " + t.getMessage());
                            return null;
                        }
                    }
                };
            }
            catch (Exception e) {
                daoFactory = null;
                logger.error("static: Failed creation of the thread local singleton: " + e.getMessage());
            }
            catch (Throwable t) {
                logger.error("static: Fatal error when creating singleton instance: " + t.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("static - Created DAOFactorySingleton instance (static thread local): " + String.valueOf(daoFactory));
            }
            SINGLETON = daoFactory;
        }
    }
}

