/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DatabaseDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.GenericHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DAOFactory {
    protected boolean cached;
    protected Map<DAO, GenericHandler<?>> daoMAP = new HashMap();
    public static final int DATABASE = 1;
    public static final int DEFAULT = 1;
    protected static Logger logger = LoggerFactory.getLogger(DAOFactory.class);

    public static DAOFactory getDAOFactory() {
        return DAOFactory.getDAOFactory(1);
    }

    public static DAOFactory getDAOFactory(int datasource) {
        if (logger.isTraceEnabled()) {
            logger.trace("getDAOFactory() - datasource = " + datasource);
        }
        switch (datasource) {
            case 1: {
                return DatabaseDAOFactory.getInstance();
            }
        }
        return null;
    }

    public abstract GenericHandler<?> getDAO(DAO var1);

    public static boolean isOnDatabase() {
        return 1 == DAOFactory.getDefaultFactory();
    }

    public static int getDefaultFactory() {
        return 1;
    }
}

