/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.dao.datasource;

import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import java.util.Arrays;
import java.util.List;

public enum DAO {
    SCHEMAS_GROUP("List of all supported schemas groups", FlatFile.SCHEMAS_GROUP),
    SCHEMA("Definition of specific validation schemas", FlatFile.SCHEMA),
    FIELD("Definition of fields belonging to schemas", FlatFile.FIELD),
    SCHEMA_TO_FIELD("Link configuration between fields and schemas", FlatFile.SCHEMA_TO_FIELD),
    RANGE("Definition of ranges belonging to schemas", FlatFile.RANGE),
    RANGE_DATA("Definition of range values", FlatFile.RANGE_DATA),
    SCHEMA_VIEW("View showing all schema information", FlatFile.SCHEMA_VIEW),
    RULE_TYPE("Supported types of validation check", FlatFile.UNDEF),
    RULE_DEFINITION("Definition of specific validation rules", FlatFile.RULE_DEFINITION),
    PROTOCOL("Definition of validation rule sets", FlatFile.PROTOCOL),
    PROTOCOL_TO_RULE("Link configuration between protocols and rules", FlatFile.PROTOCOL_TO_RULE),
    RULE_TO_FIELD("Link configuration between rules and fields", FlatFile.UNDEF),
    VALIDATION_MESSAGE("Definition of all error/warning messages", FlatFile.VALIDATION_MESSAGE),
    PROTOCOL_VIEW("View showing all protocol information", FlatFile.UNDEF),
    DATA_RECORD("The input dataset to be validated", FlatFile.DATA_RECORD),
    DATA_RECORD_CORRECT("The file/table where perfect records are saved", FlatFile.DATA_RECORD_CORRECT),
    DATA_RECORD_VALID("The file/table where valid records are saved", FlatFile.DATA_RECORD_VALID),
    DATA_RECORD_WITH_ISSUES("The file/table where invalid records are saved", FlatFile.DATA_RECORD_WITH_ISSUES),
    DATA_RECORD_UNCHECKED("The file/table where unchecked records are saved", FlatFile.DATA_RECORD_UNCHECKED),
    VALIDATION_RUN("List of all performed validation runs", FlatFile.VALIDATION_RUN),
    RULE_OUTPUT("List of errors/warnings in one validation run", FlatFile.RULE_OUTPUT),
    RULE_OUTPUT_DETAIL("Details of errors/warnings in one validation run", FlatFile.RULE_OUTPUT_DETAIL),
    REFERENCE_FIELD("Configuration of the reports' \"registry fields\"", FlatFile.REFERENCE_FIELD),
    METADATA("Database metadata (key-value pairs, e.g. db_version)", FlatFile.UNDEF);

    public final String description;
    public final FlatFile fileDAO;

    private DAO(String description, FlatFile fileDAO) {
        this.description = description;
        this.fileDAO = fileDAO;
    }

    public static List<DAO> getAllDAOs() {
        return Arrays.asList(DAO.values());
    }
}

