/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    protected static Logger logger = LoggerFactory.getLogger(Validator.class);

    public void validateAndSanitizeOptions(CommandLine command, Options options) {
        if (logger.isDebugEnabled()) {
            logger.debug("validateAndSanitizeOptions() - Command line : " + String.valueOf(command));
        }
        if (command.hasOption("validate")) {
            this.validateIntegerAndPath("validate", command, options);
        }
        if (command.hasOption("gui")) {
            Object[] validateArgs = command.getOptionValues("gui");
            if (logger.isDebugEnabled()) {
                logger.debug("validateAndSanitizeOptions() - List arguments for GUI option: " + Arrays.toString(validateArgs));
            }
            logger.info("validateAndSanitizeOptions() - List arguments for GUI option: " + Arrays.toString(validateArgs));
            if (validateArgs != null && validateArgs.length == 1) {
                this.validateLabel((String)validateArgs[0], options);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("validateAndSanitizeOptions() - Invalid number of arguments for -gui option");
                }
                return;
            }
        }
        if (command.hasOption("schema")) {
            this.validateSingleInteger("schema", command, options);
        }
        if (command.hasOption("protocol")) {
            this.validateSingleInteger("protocol", command, options);
        }
        if (command.hasOption("field_info")) {
            this.validateSingleInteger("field_info", command, options);
        }
        if (command.hasOption("rules_by_field")) {
            this.validateTwoIntegers("rules_by_field", command, options);
        }
    }

    public void validateAndSanitizeTestOptions(CommandLine command, Options options) {
        Object[] validateArgs;
        if (command.hasOption("check") && (validateArgs = command.getOptionValues("check")) != null) {
            this.validateSingleInteger("check", command, options);
        }
        if (command.hasOption("engine")) {
            this.validateSingleInteger("engine", command, options);
        }
        if (command.hasOption("read")) {
            validateArgs = command.getOptionValues("read");
            if (logger.isDebugEnabled()) {
                logger.debug("validateAndSanitizeTestOptions() - List arguments for READ option : " + Arrays.toString(validateArgs));
            }
            if (validateArgs != null && validateArgs.length == 1) {
                this.validateString((String)validateArgs[0], options);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("validateAndSanitizeTestOptions() - Invalid number of arguments for -read option");
                }
                return;
            }
        }
        if (command.hasOption("range")) {
            this.validateTwoIntegers("range", command, options);
        }
        if (command.hasOption("try_rule")) {
            this.validateSingleInteger("try_rule", command, options);
        }
        if (command.hasOption("write")) {
            validateArgs = command.getOptionValues("write");
            if (logger.isDebugEnabled()) {
                logger.debug("validateAndSanitizeTestOptions() - List arguments for WRITE option : " + Arrays.toString(validateArgs));
            }
            if (validateArgs != null && validateArgs.length == 1) {
                this.validateString((String)validateArgs[0], options);
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn("validateAndSanitizeTestOptions() - Invalid number of arguments for -write option");
                }
                return;
            }
        }
    }

    private void validateSingleInteger(String action, CommandLine command, Options options) {
        Object[] validateArgs = command.getOptionValues(action);
        if (logger.isDebugEnabled()) {
            logger.debug("validateSingleInteger() - Input arguments for action " + action + " -> " + Arrays.toString(validateArgs));
        }
        if (validateArgs != null && validateArgs.length == 1) {
            this.validateInteger((String)validateArgs[0], options);
        } else {
            logger.error("validateSingleInteger() - Invalid number of arguments for " + action + " option");
            this.handleInvalidArgument(action, options);
        }
    }

    private void validateTwoIntegers(String action, CommandLine command, Options options) {
        String[] validateArgs = command.getOptionValues(action);
        if (validateArgs != null && validateArgs.length == 2) {
            this.validateInteger(validateArgs[0], options);
            this.validateInteger(validateArgs[1], options);
        } else {
            logger.error("validateTwoIntegers() - Invalid number of arguments for " + action + " option");
            this.handleInvalidArgument(action, options);
        }
    }

    private void validateIntegerAndPath(String action, CommandLine command, Options options) {
        String[] validateArgs = command.getOptionValues(action);
        if (validateArgs != null && validateArgs.length == 2) {
            this.validateInteger(validateArgs[0], options);
            this.validatePathSyntax(validateArgs[1], options);
        } else {
            logger.error("validateTwoIntegers() - Invalid number of arguments for " + action + " option");
            this.handleInvalidArgument(action, options);
        }
    }

    private void validateInteger(String integer, Options options) {
        try {
            int n = Integer.parseInt(integer);
        }
        catch (NumberFormatException e) {
            logger.error("validateInteger() - Invalid integer: " + integer);
            this.handleInvalidArgument(integer, options);
        }
    }

    private void validateString(String string, Options options) {
        String pattern = "^[a-zA-Z0-9\\s]+$";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(string);
        if (!matcher.matches()) {
            logger.error("validateString() - Invalid string: " + string);
            this.handleInvalidArgument(string, options);
        }
    }

    private void validateLabel(String string, Options options) {
        String pattern = "^[a-zA-Z0-9\\s-]+$";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(string);
        if (!matcher.matches()) {
            logger.error("validateLabel() - Invalid string: " + string);
            this.handleInvalidArgument(string, options);
        }
    }

    private void validatePathSyntax(String filePath, Options options) {
        if (!this.isValidPath(filePath)) {
            logger.error("validatePathSyntax() - Invalid file path syntax: " + filePath);
            this.handleInvalidArgument(filePath, options);
        }
    }

    private boolean isValidPath(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
        return true;
    }

    private void handleInvalidArgument(String action, Options options) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invalid argument for action: " + action);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Found invalid argument: exiting...");
        }
        System.exit(1);
    }
}

