/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.Launcher;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.DatabaseDAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.controller.SaveOptionsAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    protected static Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        Configuration.loadLoggerConfiguration();
        if (logger.isDebugEnabled()) {
            logger.debug("main() - started...");
        }
        if (DAOFactory.isOnDatabase()) {
            System.out.println("main() - Running on JPA database");
            DatabaseDAOFactory.init();
        } else {
            System.out.println("main() - Running on legacy database");
        }
        String option = null;
        Launcher launcher = new Launcher();
        option = launcher.manageOptions(args);
        if ("validate".equals(option)) {
            if (logger.isInfoEnabled()) {
                logger.info("main() - Exiting now (application was run in background mode)");
            }
            Main.exit();
        }
    }

    public static void exit() {
        if (logger.isWarnEnabled()) {
            logger.warn("exit() - Closing application because running in background mode");
            logger.warn("exit() - This is necessary to correctly handle changes in license status (should never happen in GUI mode)");
            logger.warn("");
        }
        Configuration configuration = Configuration.getInstance();
        ValidationOptions validationOptions = configuration.getValidationOptions();
        MainController mainController = new MainController(null);
        SaveOptionsAction saveOptionsAction = new SaveOptionsAction(mainController);
        saveOptionsAction.setValidationOptions(validationOptions);
        saveOptionsAction.saveValidationOptions();
        System.exit(0);
    }

    private static void checkLicense() {
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        boolean licenseAccepted = validationOptions.checkLicenseKey();
        if (logger.isDebugEnabled()) {
            logger.debug("checkLicense() - License Accepted (before panel) ?" + licenseAccepted);
        }
        if (!licenseAccepted) {
            boolean showWarning = false;
            String licenseKey = validationOptions.getValue(Property.GUI_LICENSE_VALUE);
            boolean demoMode = validationOptions.isDemoMode(licenseKey);
            if (logger.isDebugEnabled()) {
                logger.debug("checkLicense() - License status: licenseKey = " + licenseKey + "; demoMode = " + demoMode);
            }
            if (!demoMode) {
                if (logger.isInfoEnabled()) {
                    logger.info("checkLicense(): checking license without a GUI");
                }
                licenseAccepted = validationOptions.checkLicenseKey();
                if (logger.isDebugEnabled()) {
                    logger.debug("checkLicense() - License Accepted (after panel) ?" + licenseAccepted);
                }
                if (!licenseAccepted) {
                    validationOptions.setValue(Property.GUI_LICENSE_VALUE, "demo");
                    showWarning = true;
                }
            }
            if (demoMode || showWarning) {
                if (logger.isDebugEnabled()) {
                    logger.debug("checkLicense() - Application is in demoMode OR showWarning -> showLicenseReminder()");
                }
                Main.showLicenseReminder();
            }
        }
    }

    private static void showLicenseReminder() {
        Object message = "This is a friendly reminder about the usage license.\n\n";
        message = (String)message + "The license allowing to use this application has not been accepted yet.\n";
        message = (String)message + "The application will run in demo mode, meaning that no validation process can be started.\n";
        message = (String)message + "To fully exploit all the application features, please accept the user license.\n\n";
        message = (String)message + "You can accept the license at any time from the Help - About entry (top menu).";
        if (logger.isWarnEnabled()) {
            logger.warn("checkLicense():\n" + (String)message);
        }
        JOptionPane.showMessageDialog(null, message, "Warning", 2);
    }
}

