/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import eu.europa.ec.jrc.qcs.gui.view.ProgressView;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeel {
    protected static Logger logger = LoggerFactory.getLogger(LookAndFeel.class);

    public static void setLookAndFeel() {
        UIManager.LookAndFeelInfo laf = LookAndFeel.getPreferredLookAndFeel();
        try {
            UIManager.setLookAndFeel(laf.getClassName());
            if (logger.isDebugEnabled()) {
                logger.debug("setLookAndFeel() - Loaded look and feel: " + laf.getName() + " [" + String.valueOf(UIManager.getLookAndFeel()) + "]");
            }
        }
        catch (Exception e) {
            logger.error("setLookAndFeel() - Preferred LAF not found");
            LookAndFeel.setSystemLookAndFeel();
        }
        if ("Nimbus".equals(laf.getName())) {
            UIManager.getLookAndFeelDefaults().put("nimbusOrange", ProgressView.FOREGROUND);
            if (logger.isDebugEnabled()) {
                logger.debug("setLookAndFeel() - Changed Nimbus orange property");
            }
        }
    }

    protected static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.error("setSystemLookAndFeel() - System LAF not found: using default");
        }
    }

    protected static UIManager.LookAndFeelInfo getPreferredLookAndFeel() {
        int counter = 0;
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (logger.isDebugEnabled()) {
                logger.debug("getPreferredLookAndFeel() - Found installed look and feel: [" + laf.getName() + "]");
            }
            if ("Nimbus".equals(laf.getName())) {
                return laf;
            }
            if (counter++ <= 10) continue;
            if (logger.isInfoEnabled()) {
                logger.info("getPreferredLookAndFeel() - No preferred LAF after " + counter + " tries -> loading default LAF (Nimbus)");
            }
            return new UIManager.LookAndFeelInfo("Nimbus", "javax.swing.plaf.nimbus.NimbusLookAndFee");
        }
        if (logger.isInfoEnabled()) {
            logger.info("getPreferredLookAndFeel() - Loading default LAF (Nimbus)");
        }
        return new UIManager.LookAndFeelInfo("Nimbus", "javax.swing.plaf.nimbus.NimbusLookAndFeel");
    }
}

