/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.Daemon;
import eu.europa.ec.jrc.qcs.LookAndFeel;
import eu.europa.ec.jrc.qcs.Validator;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2020;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultProtocolID;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.gui.controller.CheckLicenseAction;
import eu.europa.ec.jrc.qcs.gui.controller.MainController;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import eu.europa.ec.jrc.qcs.gui.model.ListDataModel;
import eu.europa.ec.jrc.qcs.gui.model.MonitorModel;
import eu.europa.ec.jrc.qcs.gui.model.ValidationProgressModel;
import eu.europa.ec.jrc.qcs.gui.view.AlertDialog;
import eu.europa.ec.jrc.qcs.gui.view.MainFrameImpl;
import eu.europa.ec.jrc.qcs.gui.view.MainView;
import eu.europa.ec.jrc.qcs.gui.view.MainViewImpl;
import eu.europa.ec.jrc.qcs.gui.view.MenuBar;
import eu.europa.ec.jrc.qcs.gui.view.MonitorView;
import eu.europa.ec.jrc.qcs.gui.view.ProgressView;
import eu.europa.ec.jrc.qcs.gui.view.ValidationBar;
import eu.europa.ec.jrc.qcs.test.DAOReader;
import eu.europa.ec.jrc.qcs.test.MainTester;
import eu.europa.ec.jrc.qcs.test.SchemasAnalyzer;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private MainView view;
    private MainController controller;
    public static final String HELP = "help";
    public static final String GUI = "gui";
    public static final String VALIDATE = "validate";
    public static final String DAEMON = "daemon";
    public static final String SCHEMA = "schema";
    public static final String PROTOCOL = "protocol";
    public static final String RULES_BY_FIELD = "rules_by_field";
    public static final String FIELD_INFO = "field_info";
    public static final String EXPORT_FILES = "export_files";
    public static final String TEST = "test";
    public static final String NONE = "none";
    public static final String ERROR = "error";
    public static final int DEFAULT_PROTOCOL_ID = DefaultProtocolID.INCIDENCE_2020.id;
    protected static Logger logger = LoggerFactory.getLogger(Launcher.class);

    public String manageOptions(String[] args) {
        Options options = new Options();
        DefaultParser parser = new DefaultParser();
        String guiDescription = "Open user GUI";
        String validateDescription = "Perform validation on the target file. Default values are defined in the \"application.properties\" file";
        String daemonDescription = "Perform validation on the dataset located in target path. Can be run also in bulk mode";
        String schemaDescription = "Load target schema data";
        String protocolDescription = "Shows all rules in target protocol";
        String fieldInfoDescription = "Shows all information about target field";
        String exportFilesDescription = "Export the list of all configuration files";
        String rulesByfieldDescription = "Shows all rules addressing a target field (for a given protocol)";
        String testDescription = "Executes embedded test units.\nUse \"-t -a\" to list all test commands (or --test --aid)";
        Option help = Option.builder((String)"h").longOpt(HELP).desc("Print available options").build();
        Option gui = Option.builder((String)"g").longOpt(GUI).desc(guiDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("comment").build();
        Option validate = Option.builder((String)"v").longOpt(VALIDATE).desc(validateDescription).optionalArg(true).hasArg().numberOfArgs(2).argName("protocolId file").build();
        Option daemon = Option.builder((String)"d").longOpt(DAEMON).desc(daemonDescription).optionalArg(true).hasArg().numberOfArgs(5).argName("protocolId path_in path_out time test").build();
        Option protocol = Option.builder((String)"p").longOpt(PROTOCOL).desc(protocolDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("protocolId").build();
        Option fieldInfo = Option.builder((String)"fi").longOpt(FIELD_INFO).desc(fieldInfoDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("fieldId").build();
        Option exportFiles = Option.builder((String)"ef").longOpt(EXPORT_FILES).desc(exportFilesDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("protocolId").build();
        Option test = Option.builder((String)"t").longOpt(TEST).desc(testDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("target").build();
        Option schema = Option.builder((String)"s").longOpt(SCHEMA).desc(schemaDescription).hasArgs().numberOfArgs(1).argName("schemaID").build();
        Option rules_by_field = Option.builder((String)"rf").longOpt(RULES_BY_FIELD).desc(rulesByfieldDescription).optionalArg(true).hasArg().numberOfArgs(2).argName("fieldId protocolId").build();
        options.addOption(help);
        options.addOption(gui);
        options.addOption(validate);
        options.addOption(daemon);
        options.addOption(schema);
        options.addOption(protocol);
        options.addOption(fieldInfo);
        options.addOption(exportFiles);
        options.addOption(rules_by_field);
        options.addOption(test);
        if (logger.isDebugEnabled()) {
            logger.debug("Running main launcher with args: " + Arrays.toString(args));
        }
        CommandLine command = null;
        Validator validator = new Validator();
        try {
            command = parser.parse(options, args);
            validator.validateAndSanitizeOptions(command, options);
        }
        catch (ParseException e) {
            logger.error("manageOptions() - Error passing input arguments: " + String.valueOf(args) + " -> " + e.getMessage());
            this.printHelp(options);
            return ERROR;
        }
        if (command.hasOption(HELP)) {
            this.printHelp(options);
            return HELP;
        }
        if (command.hasOption(TEST)) {
            if (logger.isInfoEnabled()) {
                logger.info("Original input arguments: " + Arrays.toString(args));
            }
            Object[] testArguments = this.unshiftArguments(args);
            if (logger.isInfoEnabled()) {
                logger.info("Forwarding arguments to test module: " + Arrays.toString(testArguments));
            }
            new MainTester().manageOptions((String[])testArguments);
            return TEST;
        }
        if (command.hasOption(GUI)) {
            String comment = null;
            String[] arguments = command.getOptionValues(GUI);
            if (arguments != null && arguments.length > 0) {
                comment = arguments[0];
            }
            Configuration.getInstance().setComment(comment);
            if (logger.isInfoEnabled()) {
                if (comment == null) {
                    logger.info("manageOptions() - Running GUI without additional comment");
                } else {
                    logger.info("manageOptions() - Running GUI with additional comment: \"" + comment + "\"");
                }
            }
            this.openGUI();
            return GUI;
        }
        if (command.hasOption(VALIDATE)) {
            int protocolID = 0;
            String filePath = null;
            Object[] arguments = command.getOptionValues(VALIDATE);
            if (logger.isDebugEnabled()) {
                logger.debug("manageOptions() - Parsing arguments: " + Arrays.toString(arguments));
            }
            if (arguments != null) {
                if (arguments.length > 0) {
                    protocolID = this.parseIntegerValue((String)arguments[0]);
                }
                if (arguments.length > 1) {
                    filePath = new String((String)arguments[1]);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("manageOptions() - Parsed dataset argument: " + filePath);
            }
            if (protocolID > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("manageOptions() - Using protocolID         : " + protocolID);
                }
            } else {
                String protocolAsString = Configuration.getInstance().getProperty(Property.DEFAULT_PROTOCOL);
                try {
                    protocolID = Integer.parseInt(protocolAsString);
                }
                catch (NumberFormatException e) {
                    logger.error("manageOptions() - Wrong default protocolID : " + protocolAsString);
                    protocolID = DEFAULT_PROTOCOL_ID;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions() - Using default protocolID  : " + protocolID);
                }
            }
            if (filePath != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("manageOptions() - File from argument       : " + filePath);
                }
            } else {
                filePath = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_FILE);
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions() - Using default file        : " + filePath);
                }
            }
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            if (logger.isDebugEnabled()) {
                logger.debug("manageOptions() - Setting file's path : " + filePath);
            }
            DataSetReader dataSetReader = validationEngine.getDataSetReader();
            dataSetReader.setFilePath(filePath);
            validationEngine.run();
            return VALIDATE;
        }
        if (command.hasOption(DAEMON)) {
            int protocolID = 0;
            String inputPath = null;
            String outputPath = null;
            int intervalTime = 0;
            boolean testSuite = false;
            Object[] arguments = command.getOptionValues(DAEMON);
            if (logger.isDebugEnabled()) {
                logger.debug("manageOptions(DAEMON) - Parsing arguments              : " + Arrays.toString(arguments));
            }
            if (arguments != null) {
                if (arguments.length > 0) {
                    protocolID = this.parseIntegerValue((String)arguments[0]);
                }
                if (arguments.length > 1) {
                    inputPath = new String((String)arguments[1]);
                }
                if (arguments.length > 2) {
                    outputPath = new String((String)arguments[2]);
                }
                if (arguments.length > 3) {
                    intervalTime = this.parseIntegerValue((String)arguments[3]);
                }
                if (arguments.length > 4) {
                    boolean bl = testSuite = arguments[4] != null;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("manageOptions(DAEMON) - Parsed input path              : " + inputPath);
                logger.debug("manageOptions(DAEMON) - Parsed output path             : " + outputPath);
            }
            if (protocolID > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("manageOptions(DAEMON) - Using protocolID               : " + protocolID);
                }
            } else {
                String protocolAsString = Configuration.getInstance().getProperty(Property.DEFAULT_PROTOCOL);
                try {
                    protocolID = Integer.parseInt(protocolAsString);
                }
                catch (NumberFormatException e) {
                    logger.error("manageOptions(DAEMON) - Wrong default protocolID       : " + protocolAsString);
                    protocolID = DEFAULT_PROTOCOL_ID;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions(DAEMON) - Using default protocolID        : " + protocolID);
                }
            }
            if (inputPath != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("manageOptions(DAEMON) - Input path (argument)          : " + inputPath);
                }
            } else {
                inputPath = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_DIR);
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions(DAEMON) - Using default input path        : " + inputPath);
                }
            }
            if (outputPath != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("manageOptions(DAEMON) - Output path (argument)         : " + outputPath);
                }
            } else {
                outputPath = Configuration.getInstance().getProperty(Property.DEFAULT_INPUT_DIR);
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions(DAEMON) - Using default output path       : " + outputPath);
                }
            }
            if (intervalTime > 0) {
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions(DAEMON) - Run daemon with intervalTime    : " + intervalTime);
                }
                Daemon daemonObj = new Daemon(protocolID, inputPath, outputPath, intervalTime);
                daemonObj.startDaemon(true);
            } else {
                String lockDirectory;
                if (logger.isInfoEnabled()) {
                    logger.info("manageOptions(DAEMON) - No intervalTime -> Run in bulk mode");
                }
                if (Daemon.checkFlagFile(lockDirectory = this.getJarAboslutePath(), "flag_running")) {
                    logger.error("manageOptions(DAEMON) - A bulk process is already running, exiting now.");
                    logger.error("manageOptions(DAEMON) - Please check status of the other bulk process, or try later.");
                    return DAEMON;
                }
                Daemon.createFlagFile(lockDirectory, "flag_running");
                Daemon daemonObj = new Daemon(protocolID, inputPath, outputPath);
                daemonObj.startBulkValidation(testSuite);
                Daemon.deleteFlagFile(lockDirectory, "flag_running");
            }
            return DAEMON;
        }
        if (command.hasOption(SCHEMA)) {
            String[] params = command.getOptionValues(SCHEMA);
            int schemaID = this.parseIntegerValue(params[0]);
            if (schemaID < 0) {
                logger.info("");
                logger.warn("Invalid selection of schema: " + params[0]);
                logger.info("");
            } else {
                SchemasAnalyzer schemasAnalyzer = new SchemasAnalyzer();
                schemasAnalyzer.checkSchemasIntegrity(schemaID);
                logger.info("Loading schema=" + schemaID);
                schemasAnalyzer.loadSchema(schemaID, false);
            }
            MainTester tester = new MainTester();
            tester.logAllDynamicFolder();
            return SCHEMA;
        }
        if (command.hasOption(PROTOCOL)) {
            String argument = command.getOptionValue(PROTOCOL);
            int protocolID = this.parseIntegerValue(argument);
            if (protocolID > 0) {
                logger.info("Loading protocolID : " + protocolID);
            } else {
                logger.info("Loading hard-coded protocol");
            }
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
            logger.info("LOAD SINGLE PROTOCOL");
            logger.info("");
            validationEngine.analyzeProtocol();
            return PROTOCOL;
        }
        if (command.hasOption(FIELD_INFO)) {
            String argument = command.getOptionValue(FIELD_INFO);
            int fieldID = this.parseIntegerValue(argument);
            if (fieldID > 0) {
                logger.info("Loading fieldID : " + fieldID);
            } else {
                logger.error("Please specify a valida field ID");
                System.exit(0);
            }
            new DAOReader().getFieldInformation(fieldID);
            return FIELD_INFO;
        }
        if (command.hasOption(RULES_BY_FIELD)) {
            int fieldID = 0;
            int protocolID = 0;
            Object[] params = command.getOptionValues(RULES_BY_FIELD);
            logger.info("Argument arrays: " + Arrays.toString(params));
            if (params != null && params.length > 0) {
                fieldID = this.parseIntegerValue((String)params[0]);
                if (params.length > 1) {
                    protocolID = this.parseIntegerValue((String)params[1]);
                }
            }
            if (fieldID <= 0) {
                fieldID = DefaultFieldIDencr2020.INCIDENCE_AGE.id;
                logger.info("Using default fielID: " + fieldID);
            }
            if (protocolID <= 0) {
                protocolID = DefaultProtocolID.INCIDENCE_2020.id;
                logger.info("Using default protocolID: " + protocolID);
            }
            logger.info("Loading list of rules addressing field " + fieldID + " (for protocol " + protocolID + ")");
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
            logger.info("LIST OF RULES");
            logger.info("");
            validationEngine.getRulesByFieldID(fieldID, protocolID);
            return RULES_BY_FIELD;
        }
        if (command.hasOption(EXPORT_FILES)) {
            String argument = command.getOptionValue(EXPORT_FILES);
            int protocolID = this.parseIntegerValue(argument);
            if (protocolID > 0) {
                logger.info("Listing files for protocolID : " + protocolID);
            } else {
                protocolID = 11;
                logger.info("Listing files for default protocol: " + protocolID);
            }
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            validationEngine.hardReset();
            List<AbstractRule> validRules = validationEngine.loadAllRules();
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
            logger.info("LIST OF CONFIGURATION FILES");
            logger.info("");
            StringBuilder builder = new StringBuilder("\n");
            HashMap countByPath = new HashMap();
            for (AbstractRule rule : validRules) {
                RuleConfiguration cfg = rule.getRuleConfiguration();
                List<LocalFile> files = cfg.getConfigurationFiles();
                String configPath = cfg.getConfigurationPath();
                if (files == null) continue;
                String errorCode = cfg.getValidationMessage().getCode();
                String className = rule.getClassName();
                builder.append("\n");
                builder.append("Rule ").append(errorCode).append(" --> ").append(className).append("\n");
                String eol = "";
                for (LocalFile file : files) {
                    builder.append(eol);
                    builder.append("    - ").append(configPath).append("/").append(file.getFileName());
                    eol = "\n";
                }
                if (countByPath.containsKey(configPath)) {
                    ((Set)countByPath.get(configPath)).addAll(files.stream().map(LocalFile::getFileName).collect(Collectors.toList()));
                    continue;
                }
                countByPath.put(configPath, new HashSet());
            }
            builder.append("\n\nTotal configured files by path: \n");
            countByPath.entrySet().forEach(stringIntegerEntry -> builder.append((String)stringIntegerEntry.getKey()).append(":").append(((Set)stringIntegerEntry.getValue()).size()).append("\n"));
            logger.info(builder.toString());
            return EXPORT_FILES;
        }
        Object message = "At least one parameter is necessary to run the application properly.\n";
        message = (String)message + "For further information, run the application with the \"-help\" option.";
        logger.warn((String)message);
        return NONE;
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HELP, options);
        System.out.println();
    }

    public void openGUI() {
        Thread.currentThread().setName("QCS-Main");
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LookAndFeel.setLookAndFeel();
                    Launcher.this.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Opened main frame !!!");
        }
    }

    public void createAndShowGUI() {
        Configuration configuration = Configuration.getInstance();
        ValidationOptions validationOptions = configuration.getValidationOptions();
        if (logger.isInfoEnabled()) {
            logger.info("createAndShowGUI() - Starting now...");
        }
        DataSetModel dataSetModel = new DataSetModel();
        ValidationEngine validationEngine = new ValidationEngine();
        List<SchemasGroup> schemaGroups = validationOptions.getSchemaGroups();
        List<Protocol> protocols = validationOptions.getProtocols();
        ListDataModel<SchemasGroup> schemaGroupDataModel = new ListDataModel<SchemasGroup>(schemaGroups);
        ListDataModel<Protocol> protocolDataModel = new ListDataModel<Protocol>(protocols);
        ComboBoxUIModel<SchemasGroup> schemaGroupUIModel = new ComboBoxUIModel<SchemasGroup>(schemaGroupDataModel);
        ComboBoxUIModel<Protocol> protocolUIModel = new ComboBoxUIModel<Protocol>(protocolDataModel);
        ValidationProgressModel progressModel = new ValidationProgressModel();
        MonitorModel monitorModel = new MonitorModel();
        String protocolID = Configuration.getInstance().getProperty(Property.DEFAULT_PROTOCOL);
        protocolDataModel.setDefaultItemID(protocolID);
        protocolUIModel.setEntityName("ProtocolUIModel");
        schemaGroupUIModel.setEntityName("SchemaGroupUIModel");
        monitorModel.setSchemaGroupDataModel(schemaGroupDataModel);
        monitorModel.setProtocolDataModel(protocolDataModel);
        MainFrameImpl mainFrame = new MainFrameImpl();
        this.view = new MainViewImpl(mainFrame);
        MenuBar menuBar = new MenuBar();
        ValidationBar buttons = new ValidationBar(dataSetModel);
        MonitorView monitor = new MonitorView(monitorModel);
        ProgressView progressBar = new ProgressView(progressModel);
        buttons.setSchemaGroupUIModel(schemaGroupUIModel);
        buttons.setProtocolUIModel(protocolUIModel);
        buttons.init();
        buttons.setFrame(mainFrame);
        this.view.setButtonsBar(buttons);
        this.view.setMonitorView(monitor);
        this.view.setProgessView(progressBar);
        this.controller = new MainController(this.view);
        this.controller.setDataSetModel(dataSetModel);
        this.controller.setOptionsModel(validationOptions);
        this.controller.setEngineModel(validationEngine);
        this.controller.setSchemaGroupUIModel(schemaGroupUIModel);
        this.controller.setProtocolUIModel(protocolUIModel);
        this.controller.setMonitorModel(monitorModel);
        this.controller.addValidationMonitor(progressModel);
        this.controller.addValidationMonitor(monitorModel);
        this.controller.addCheckIntegrityMonitor(monitorModel);
        this.controller.setGeneralActions(menuBar);
        this.controller.setValidationActions(buttons);
        mainFrame.setJMenuBar(menuBar.getMenuBar());
        mainFrame.getContentPane().add(this.view.getMainPanel());
        mainFrame.pack();
        mainFrame.centre();
        mainFrame.setVisible(true);
        AlertDialog.initPanel(mainFrame);
        this.checkLicense();
        if (logger.isDebugEnabled()) {
            logger.debug("createAndShowGUI() - Completed");
        }
    }

    public void checkLicense() {
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        boolean licenseAccepted = validationOptions.checkLicenseKey();
        if (logger.isDebugEnabled()) {
            logger.debug("checkLicense() - License Accepted (before panel) ?" + licenseAccepted);
        }
        if (!licenseAccepted) {
            boolean showWarning = false;
            String licenseKey = validationOptions.getValue(Property.GUI_LICENSE_VALUE);
            boolean demoMode = validationOptions.isDemoMode(licenseKey);
            if (logger.isDebugEnabled()) {
                logger.debug("checkLicense() - License status: licenseKey = " + licenseKey + "; demoMode = " + demoMode);
            }
            CheckLicenseAction checkLicenseAction = this.controller.getCheckLicenseAction();
            if (!demoMode) {
                if (logger.isInfoEnabled()) {
                    logger.info("checkLicense(): showing license for the first time");
                }
                checkLicenseAction.actionPerformed(null);
                licenseAccepted = validationOptions.checkLicenseKey();
                if (logger.isDebugEnabled()) {
                    logger.debug("checkLicense() - License Accepted (after panel) ?" + licenseAccepted);
                }
                if (!licenseAccepted) {
                    validationOptions.setValue(Property.GUI_LICENSE_VALUE, "demo");
                    showWarning = true;
                }
            }
            if (demoMode || showWarning) {
                if (logger.isDebugEnabled()) {
                    logger.debug("checkLicense() - Application is in demoMode OR showWarning -> showLicenseReminder()");
                }
                checkLicenseAction.notifyExitingNow();
            }
        }
    }

    protected int parseIntegerValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected String[] unshiftArguments(String[] args) {
        Object[] newArguments;
        if (args.length > 1) {
            newArguments = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArguments[i] = args[i + 1];
            }
        } else {
            newArguments = args;
        }
        if (logger.isInfoEnabled()) {
            logger.info("unshiftArguments() - New args: " + Arrays.toString(newArguments));
        }
        return newArguments;
    }

    protected String getComment() {
        String comment = Configuration.getInstance().getComment();
        if (comment == null) {
            comment = "unknown";
        }
        if (logger.isInfoEnabled()) {
            logger.info("getDomain() - Running in environment: " + comment);
        }
        return comment;
    }

    protected String getJarAboslutePath() {
        String path = null;
        try {
            File jarFile = new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            path = jarFile.getParent();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            path = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getJarAboslutePath() - Found path: " + path);
        }
        return path;
    }

    public void updateSchemaGroupModel(final ListDataModel<SchemasGroup> model) {
        Thread thread = new Thread(){

            @Override
            public synchronized void run() {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                logger.info("Emulating an asynchronous model update...");
                SchemasGroup new_sg = new SchemasGroup("5", "New", "New Schema", "0");
                SchemasGroup old_sg = new SchemasGroup(2);
                model.addElement(new_sg);
                model.removeElement(old_sg);
            }
        };
        thread.start();
    }
}

