/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import eu.europa.ec.jrc.qcs.ValidationTask;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.gui.model.workers.ValidationWorker;
import eu.europa.ec.jrc.qcs.report.ReportFormat;
import eu.europa.ec.jrc.qcs.report.ReportType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daemon {
    protected int protocolId;
    protected String inputPath;
    protected String outputPath;
    protected int interval;
    protected ValidationEngine validationEngine;
    protected boolean endless;
    protected long counter;
    protected ReportType reportType;
    public static final String FLAG_START = "flag_start";
    public static final String FLAG_RUNNING = "flag_running";
    public static final String FLAG_DONE = "flag_done";
    public static final String FLAG_ERROR = "flag_error";
    public static final String FLAG_STOP = "flag_stop";
    public static final String EMPTY_INPUT_FOLDER = "empty_input";
    public static final List<String> WRONG_INPUT_FOLDER = Arrays.asList("no_input");
    public static final String TOO_MANY_INPUT = "too_many_input";
    protected static Logger logger = LoggerFactory.getLogger(Daemon.class);

    public Daemon(int protocolId) {
        this.protocolId = protocolId;
        this.validationEngine = new ValidationEngine();
        this.validationEngine.setProtocolView(this.protocolId);
        ProtocolView protocolView = this.validationEngine.getProtocolView();
        Schema schema = protocolView.getProtocol().getSchema();
        this.reportType = schema.getReportType();
    }

    public Daemon(int protocolId, String inputPath, String outputPath) {
        this(protocolId);
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.interval = 0;
    }

    public Daemon(int protocolId, String inputPath, String outputPath, int interval) {
        this(protocolId, inputPath, outputPath);
        this.interval = interval;
    }

    public void startBulkValidation(boolean testSuite) {
        if (logger.isDebugEnabled()) {
            logger.debug("executeBulkValidation() - Running test-suite? " + testSuite);
        }
        DataSetReader dataSetReader = this.validationEngine.getDataSetReader();
        List<String> targetFiles = this.getAllCSVFiles(this.inputPath);
        if (logger.isDebugEnabled()) {
            logger.debug("executeBulkValidation() - Using ReportType: " + String.valueOf((Object)this.reportType));
        }
        String defaultTXTReportName = null;
        defaultTXTReportName = testSuite ? this.reportType.getReportName() + ReportFormat.TXT.getFileExtension() : this.reportType.getShortReportName() + ReportFormat.TXT.getFileExtension();
        String defaultCSVReportName = this.reportType.getReportName() + ReportFormat.CSV.getFileExtension();
        if (logger.isDebugEnabled()) {
            logger.debug("executeBulkValidation() - Fetched report name: " + this.reportType.getReportName());
        }
        for (String targetFile : targetFiles) {
            ++this.counter;
            if (logger.isInfoEnabled()) {
                logger.info("\n#######################################################################################################################\n");
                logger.info("executeBulkValidation(" + this.counter + ") - Handling file: " + targetFile + "\n");
            }
            dataSetReader.setFilePath(targetFile);
            dataSetReader.resetDataset();
            boolean validOutput = this.validateSingleDateset();
            if (!validOutput) {
                logger.error("executeBulkValidation() - Invalid output for input file : " + targetFile);
                logger.error("executeBulkValidation() - Skipping copy of reports in   : " + this.outputPath);
                continue;
            }
            Path path = Paths.get(targetFile, new String[0]);
            String fileName = path.getFileName().toString();
            int extensionIndex = fileName.lastIndexOf(46);
            String fileNameWithoutExtension = fileName.substring(0, extensionIndex);
            String testSuiteTXTFileName = fileNameWithoutExtension + ".txt";
            String testSuiteCSVFileName = fileNameWithoutExtension + ".csv";
            boolean copiedTXTReport = this.copyAndRenameOutputReport(defaultTXTReportName, testSuiteTXTFileName);
            boolean copiedCSVReport = this.copyAndRenameOutputReport(defaultCSVReportName, testSuiteCSVFileName);
            if (copiedTXTReport && copiedCSVReport) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("executeBulkValidation() - Copied file: " + targetFile);
                continue;
            }
            if (!copiedTXTReport) {
                logger.error("executeBulkValidation(): Error copying TXT report in output directory for dataset: " + targetFile);
            }
            if (copiedCSVReport) continue;
            logger.error("executeBulkValidation(): Error copying TXT report in output directory for dataset: " + targetFile);
        }
        if (logger.isInfoEnabled()) {
            logger.info("\n");
            logger.info("\n#######################################################################################################################\n");
            logger.info("executeBulkValidation() - Executed validation of " + this.counter + " files");
            logger.info("executeBulkValidation() - Input directory  : " + this.inputPath);
            logger.info("executeBulkValidation() - Output directory : " + this.outputPath);
            logger.info("executeBulkValidation() - Press any key to close this window");
        }
    }

    public void startDaemon(boolean endless) {
        this.endless = endless;
        if (logger.isDebugEnabled()) {
            logger.debug("startDaemon() - Using ReportType: " + String.valueOf((Object)this.reportType));
        }
        do {
            boolean flagStop;
            ++this.counter;
            boolean flagStart = Daemon.checkFlagFile(this.inputPath, FLAG_START);
            boolean flagRunning = Daemon.checkFlagFile(this.inputPath, FLAG_RUNNING);
            boolean flagDone = Daemon.checkFlagFile(this.outputPath, FLAG_DONE);
            boolean flagError = Daemon.checkFlagFile(this.outputPath, FLAG_ERROR);
            boolean bl = flagStop = Daemon.checkFlagFile(this.inputPath, FLAG_STOP) || Daemon.checkFlagFile(this.outputPath, FLAG_STOP);
            if (flagStop) {
                this.endless = false;
                if (logger.isWarnEnabled()) {
                    logger.warn("startDaemon(): Found flag stop file -> stopping in few seconds...");
                }
            }
            if (!flagStart || flagRunning || flagDone || flagError) {
                if (logger.isDebugEnabled()) {
                    logger.debug("startDaemon(): waiting for flag_start in directory: " + this.inputPath);
                }
                if (flagRunning) {
                    logger.error("startDaemon(): flag_running is still in input directory. Please check QCS status");
                }
                if (flagError) {
                    logger.error("startDaemon(): flag_error is still in output directory. Open file to acknowledge error's details");
                }
                if (flagDone) {
                    logger.debug("startDaemon(): flag_done is still in output directory. Please copy output reports and delete it");
                }
                this.pauseAndWatchdog();
                continue;
            }
            DataSetReader dataSetReader = this.validationEngine.getDataSetReader();
            String targetFile = this.getFirstCSVFile(this.inputPath);
            boolean validInput = this.isValidFile(targetFile);
            if (!validInput) {
                if (logger.isWarnEnabled()) {
                    logger.warn("startDaemon(): Invalid input : " + targetFile);
                    logger.warn("startDaemon(): Target path   : " + this.inputPath);
                    logger.warn("startDaemon(): Skipping this cycle (no validation)");
                }
                String message = "Unknown error";
                if (targetFile.equalsIgnoreCase(TOO_MANY_INPUT)) {
                    message = "Too many CSV files in input directory. The input directory can contain only ONE CSV file";
                } else if (targetFile.equalsIgnoreCase(EMPTY_INPUT_FOLDER)) {
                    message = "Input directory is empty. Please drop a CSV file before writing flag_start";
                } else {
                    message = "Wrong status of input directory. Check log file for detailed information";
                    logger.error("startDaemon() - Latest target file in input folder: " + targetFile);
                }
                Daemon.createFlagFile(this.inputPath, FLAG_ERROR, message);
                Daemon.deleteFlagFile(this.inputPath, FLAG_START);
                this.pauseAndWatchdog();
                continue;
            }
            dataSetReader.setFilePath(targetFile);
            dataSetReader.resetDataset();
            if (logger.isInfoEnabled()) {
                logger.info("\n--------------------------------------------------------------------------------");
                logger.info("startDaemon() - Executing loop   : " + this.counter);
                logger.info("startDaemon() - Target directory : " + this.inputPath);
                logger.info("startDaemon() - Target dataset   : " + targetFile);
                logger.info("\n--------------------------------------------------------------------------------");
            }
            Daemon.createFlagFile(this.inputPath, FLAG_RUNNING);
            Daemon.deleteFlagFile(this.inputPath, FLAG_START);
            boolean validOutput = this.validateSingleDateset();
            if (!validOutput) {
                if (logger.isWarnEnabled()) {
                    logger.warn("startDaemon(): Invalid output for input file: " + targetFile);
                    logger.warn("startDaemon(): Skipping copy of reports in " + this.outputPath);
                }
                Daemon.deleteFlagFile(this.inputPath, FLAG_RUNNING);
                this.pauseAndWatchdog();
                continue;
            }
            boolean copiedReports = this.copyOutputReports();
            if (copiedReports) {
                Daemon.createFlagFile(this.outputPath, FLAG_DONE);
            } else {
                String message = "Error copying reports in output directory (i.e. content of output folder is invalid).";
                Daemon.createFlagFile(this.outputPath, FLAG_ERROR, message);
            }
            Daemon.deleteFlagFile(this.inputPath, FLAG_RUNNING);
            this.pauseAndWatchdog();
        } while (this.endless);
        Daemon.deleteFlagFile(this.inputPath, FLAG_START);
        Daemon.deleteFlagFile(this.inputPath, FLAG_RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateSingleDateset() {
        ValidationWorker validationWorker = new ValidationWorker(this.validationEngine);
        this.validationEngine.setValidationWorker(validationWorker);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ValidationTask task = new ValidationTask(this.validationEngine);
        Future<List<String>> future = executor.submit(task);
        if (logger.isDebugEnabled()) {
            logger.debug("validateSingleDateset() - Started validation worker : " + String.valueOf(validationWorker));
        }
        try {
            List<String> results = future.get();
            for (String result : results) {
                logger.info("validateSingleDateset() - Completed validation task : " + result);
            }
        }
        catch (Exception e) {
            logger.error("validateSingleDateset() - Error when excuting task: " + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
            if (logger.isInfoEnabled()) {
                logger.info("validateSingleDateset() - Stopped validation worker : " + String.valueOf(validationWorker));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("validateSingleDateset() - Exiting after having closed worker : " + String.valueOf(validationWorker));
        }
        logger.info("validateSingleDateset() - Exiting after having closed worker : " + String.valueOf(validationWorker));
        return true;
    }

    protected void pauseAndWatchdog() {
        if (logger.isInfoEnabled()) {
            logger.info("pauseAndWatchdog() - Loop " + this.counter + ": Waiting " + this.interval + " seconds");
        }
        this.pauseThread(this.interval);
    }

    public static boolean checkFlagFile(String absolutePath, String flagName) {
        if (absolutePath == null || absolutePath.isEmpty() || flagName == null || flagName.isEmpty()) {
            logger.error("checkFlagFile() - Invalid input: absolutePath and flagName must not be null or empty");
            return false;
        }
        File directory = Paths.get(absolutePath, new String[0]).toFile();
        if (!directory.isDirectory()) {
            logger.error("checkFlagFile() - The provided path is not a valid directory: " + absolutePath);
            return false;
        }
        File flagFile = Paths.get(absolutePath, flagName).toFile();
        if (flagFile.exists() && flagFile.isFile()) {
            if (logger.isInfoEnabled()) {
                logger.info("checkFlagFile() - " + flagName + " found in directory: " + absolutePath);
            }
            return true;
        }
        if (!flagName.equalsIgnoreCase(FLAG_RUNNING) && !flagName.equalsIgnoreCase(FLAG_ERROR) && logger.isInfoEnabled()) {
            logger.info("checkFlagFile() - " + flagName + " NOT found in directory: " + absolutePath);
        }
        return false;
    }

    public static boolean createFlagFile(String absolutePath, String flagName) {
        return Daemon.createFlagFile(absolutePath, flagName, null);
    }

    protected static boolean createFlagFile(String absolutePath, String flagName, String content) {
        if (absolutePath == null || absolutePath.isEmpty() || flagName == null || flagName.isEmpty()) {
            logger.error("createFlagFile() - Invalid input: absolutePath and flagName must not be null or empty.");
            return false;
        }
        File directory = Paths.get(absolutePath, new String[0]).toFile();
        if (!directory.isDirectory()) {
            logger.error("createFlagFile() - The provided path is not a valid directory: " + absolutePath);
            return false;
        }
        File flagFile = new File(directory, flagName);
        try {
            if (flagFile.createNewFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("createFlagFile() - Successfully created '{}' file in directory: {}", (Object)flagName, (Object)absolutePath);
                }
            } else {
                logger.info("createFlagFile() - '{}' file already exists in directory: {}", (Object)flagName, (Object)absolutePath);
            }
            if (content != null) {
                try (FileWriter writer = new FileWriter(flagFile);){
                    writer.write(content);
                    if (logger.isDebugEnabled()) {
                        logger.debug("createFlagFile() - Successfully wrote content to '{}' file in directory: {}", (Object)flagName, (Object)absolutePath);
                    }
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error("createFlagFile() - Error creating '{}' file in directory: {} - Exception: {}", new Object[]{flagName, absolutePath, e.getMessage()});
            return false;
        }
    }

    public static boolean deleteFlagFile(String absolutePath, String flagName) {
        if (absolutePath == null || absolutePath.isEmpty() || flagName == null || flagName.isEmpty()) {
            logger.error("deleteFlagFile() - Invalid input: absolutePath and flagName must not be null or empty.");
            return false;
        }
        File directory = Paths.get(absolutePath, new String[0]).toFile();
        if (!directory.isDirectory()) {
            logger.error("deleteFlagFile() - The provided path is not a valid directory: {}", (Object)absolutePath);
            return false;
        }
        File flagFile = new File(directory, flagName);
        if (!flagFile.exists()) {
            logger.info("deleteFlagFile() - '{}' file does not exist in directory: {}", (Object)flagName, (Object)absolutePath);
            return true;
        }
        if (flagFile.delete()) {
            logger.debug("deleteFlagFile() - Successfully deleted '{}' file in directory: {}", (Object)flagName, (Object)absolutePath);
            return true;
        }
        logger.error("deleteFlagFile() - Failed to delete '{}' file in directory: {}", (Object)flagName, (Object)absolutePath);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getFirstCSVFile(String absolutePath) {
        String fileName;
        block5: {
            fileName = null;
            File directory = new File(absolutePath);
            if (directory.isDirectory()) {
                File[] files = directory.listFiles((dir, name) -> name.endsWith(".csv"));
                if (files != null && files.length > 0) {
                    fileName = files[0].getAbsolutePath();
                    if (files.length > 1) {
                        logger.warn("getFirstCSVFile() - Input directory contains more than one file -> doing nothing");
                        return TOO_MANY_INPUT;
                    }
                    break block5;
                } else {
                    logger.error("getFirstCSVFile() - Input directory is empty -> doing nothing. Input directory:  " + absolutePath);
                    return EMPTY_INPUT_FOLDER;
                }
            }
            logger.error("getFirstCSVFile() - Input path is not a directory: " + absolutePath);
            logger.info("getFirstCSVFile() - Ending daemon now!");
            System.exit(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getFirstCSVFile() - Choosen input file: " + fileName);
        }
        return fileName;
    }

    protected List<String> getAllCSVFiles(String absolutePath) {
        ArrayList<String> list = new ArrayList<String>();
        File directory = new File(absolutePath);
        if (!directory.exists()) {
            logger.error("getAllCSVFiles() - Directory does not exist: " + absolutePath);
            return WRONG_INPUT_FOLDER;
        }
        if (!directory.isDirectory()) {
            logger.error("getAllCSVFiles() - Input path is not a directory: " + absolutePath);
            return WRONG_INPUT_FOLDER;
        }
        File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".csv"));
        if (files != null && files.length > 0) {
            for (File file : files) {
                list.add(file.getAbsolutePath());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getAllCSVFiles() - Found " + list.size() + " CSV files in directory: " + absolutePath);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("getAllCSVFiles() - No CSV files found in directory: " + absolutePath);
        }
        return list;
    }

    protected boolean isValidFile(String absolutePath) {
        if (absolutePath.equalsIgnoreCase(EMPTY_INPUT_FOLDER)) {
            return false;
        }
        return !absolutePath.equalsIgnoreCase(TOO_MANY_INPUT);
    }

    protected boolean copyOutputReports() {
        String relativePath = ReportType.getRelativePath(this.reportType);
        String absolutePath = this.getAbsolutePathFromRelativePath(relativePath);
        if (logger.isDebugEnabled()) {
            logger.debug("copyOutputReports() - Using ReportType                : " + String.valueOf((Object)this.reportType));
            logger.debug("copyOutputReports() - Copying output reports from path: " + absolutePath);
        }
        final Path sourceDirectory = Paths.get(absolutePath, new String[0]);
        final Path destinationDirectory = Paths.get(this.outputPath, new String[0]);
        try {
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destinationFile = destinationDirectory.resolve(sourceDirectory.relativize(file));
                    Files.copy(file, destinationFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (AccessDeniedException e) {
            logger.error("copyOutputReports() - Failed copying output reports to target path: " + String.valueOf(destinationDirectory));
            logger.error("copyOutputReports() - Please check if target path contains some open/read-only files");
            return false;
        }
        catch (IOException e) {
            logger.error("copyOutputReports() - Error copying output reports!");
            logger.info("copyOutputReports() - Copying from : " + String.valueOf(sourceDirectory));
            logger.info("copyOutputReports() - Copying to   : " + String.valueOf(destinationDirectory));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean copyAndRenameOutputReport(String reportName, String fileName) {
        Path targetFile = Paths.get(this.outputPath, fileName);
        Path sourceDirectory = Paths.get(this.getAbsolutePathFromRelativePath(ReportType.getRelativePath(this.reportType)), new String[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("copyAndRenameOutputReport() - Report name:" + reportName);
        }
        Path sourceFile = sourceDirectory.resolve(reportName);
        if (logger.isDebugEnabled()) {
            logger.debug("copyAndRenameOutputReport() - Copying file : " + String.valueOf(sourceFile));
            logger.debug("copyAndRenameOutputReport() - Renaming to  : " + String.valueOf(targetFile));
        }
        try {
            Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AccessDeniedException e) {
            logger.error("copyAndRenameOutputReport() - Access denied to file: " + String.valueOf(targetFile));
            logger.error("copyAndRenameOutputReport() - Check permissions of the destination directory");
            return false;
        }
        catch (IOException e) {
            logger.error("copyAndRenameOutputReport() - Error copying the file!");
            logger.info("copyAndRenameOutputReport() - Copying from : " + String.valueOf(sourceFile));
            logger.info("copyAndRenameOutputReport() - Copying to   : " + String.valueOf(targetFile));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected String getAbsolutePathFromRelativePath(String relativePath) {
        Path absolutePath = Paths.get(relativePath, new String[0]).toAbsolutePath();
        return absolutePath.toString();
    }

    protected void pauseThread(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("pauseThread() - Error interrupting thread:" + this.getThreadInfo());
        }
    }

    protected String getThreadInfo() {
        StringBuilder threadInfo = new StringBuilder("Thread Information:\n");
        threadInfo.append("State  : ").append((Object)Thread.currentThread().getState()).append("\n");
        threadInfo.append("Name   : ").append(Thread.currentThread().getName()).append("\n");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        String className = stackTrace[2].getClassName();
        threadInfo.append("Method : ").append(className).append(".").append(methodName).append("()\n");
        return threadInfo.toString();
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public boolean isEndless() {
        return this.endless;
    }

    public void setEndless(boolean endless) {
        this.endless = endless;
    }

    public long getCounter() {
        return this.counter;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }
}

