/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs;

import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.DatabaseDAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.LoggerConfigurationHandler;
import eu.europa.ec.jrc.qcs.dao.file.handler.PropertiesHandler;
import eu.europa.ec.jrc.qcs.dao.jpa.MetadataRepository;
import eu.europa.ec.jrc.qcs.dao.model.config.ApplicationProperties;
import eu.europa.ec.jrc.qcs.dao.model.config.Internationalization;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.PropertiesResourceBundle;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    protected static final String buildNumber = "2025-11-25-001";
    protected static Configuration configuration;
    private ApplicationProperties applicationProperties;
    private Internationalization internationalization;
    private ValidationOptions validationOptions;
    private String os = System.getProperty("os.name").toLowerCase();
    private String comment;
    private boolean runningFromJar;
    protected static Logger logger;

    public static String getBuildNumber() {
        return buildNumber;
    }

    public static Configuration getInstance() {
        if (configuration == null) {
            configuration = new Configuration();
            configuration.setRunningFromjar();
            configuration.loadApplicationProperties();
            configuration.loadInternationalizationValues();
            configuration.loadValidationOptions();
            if (logger.isInfoEnabled()) {
                logger.info("getInstance() - QCS is running in a " + configuration.getOs() + " environment");
                logger.info("getInstance() - Is Linux   ? " + configuration.isUnix());
                logger.info("getInstance() - Is Windows ? " + configuration.isWindows());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("getInstance() - Loaded configuration singleton: " + String.valueOf(configuration));
            }
        }
        return configuration;
    }

    public static void reset() {
        configuration = null;
        logger.warn("reset() - Purged all configuration DAOs");
    }

    public static void loadLoggerConfiguration() {
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.LOGGER_CONFIG);
        LoggerConfigurationHandler handler = new LoggerConfigurationHandler(connection);
        handler.getConfiguration();
        if (logger.isDebugEnabled()) {
            logger.debug("loadLoggerConfiguration() - Loaded logger configuration");
        }
    }

    public ApplicationProperties loadApplicationProperties() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadApplicationProperties() - Loading main configuration");
        }
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.PROPERTIES);
        PropertiesHandler handler = new PropertiesHandler(connection);
        Properties properties = handler.getProperties(true);
        this.applicationProperties = new ApplicationProperties(properties);
        if (this.applicationProperties.isValid()) {
            if (logger.isInfoEnabled()) {
                logger.info("loadApplicationProperties() - Loaded main configuration (valid configuration file)");
            }
        } else {
            logger.error("loadApplicationProperties() - Failed to load main configuration: found invalid configurationDTO");
        }
        return this.applicationProperties;
    }

    public Internationalization loadInternationalizationValues() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadInternationalizationValues() - Loading i18n configuration: " + String.valueOf((Object)FlatFile.I18N_CONFIG));
        }
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.I18N_CONFIG);
        PropertiesHandler handler = new PropertiesHandler(connection);
        Properties properties = handler.getProperties(true);
        PropertiesResourceBundle bundle = new PropertiesResourceBundle(properties);
        this.internationalization = new Internationalization(bundle);
        return this.internationalization;
    }

    public ValidationOptions loadValidationOptions() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadValidationOptions() - Loading options from file: " + String.valueOf((Object)FlatFile.OPTIONS));
        }
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.OPTIONS);
        PropertiesHandler handler = new PropertiesHandler(connection);
        Properties properties = handler.getProperties(false);
        this.validationOptions = new ValidationOptions(properties);
        if (this.validationOptions.isValid()) {
            if (logger.isInfoEnabled()) {
                logger.info("loadValidationOptions() - Loaded main configuration (valid configurationDTO)");
            }
        } else {
            logger.error("loadValidationOptions() - Failed to load main configuration: found invalid configurationDTO");
        }
        return this.validationOptions;
    }

    public String getDatabaseVersion() {
        MetadataRepository metadataRepository;
        String metadata;
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        String dbVersion = "Unknown";
        if (daoFactory instanceof DatabaseDAOFactory && (metadata = (metadataRepository = (MetadataRepository)daoFactory.getDAO(DAO.METADATA)).getValue("db_version")) != null) {
            dbVersion = metadata;
        }
        if (logger.isInfoEnabled()) {
            logger.info("getDatabaseVersion() - Fetched dbVersion: {}", (Object)dbVersion);
        }
        return dbVersion;
    }

    private void setRunningFromjar() {
        String className = Configuration.class.getSimpleName() + ".class";
        URL resourceUrl = Configuration.class.getResource(className);
        this.runningFromJar = resourceUrl.getProtocol().equals("jar");
        if (logger.isInfoEnabled()) {
            logger.info("runningFromJar: " + this.runningFromJar);
        }
    }

    public int getIntegerProperty(Property option) {
        int integer;
        block2: {
            String value = this.getProperty(option);
            try {
                integer = Integer.parseInt(value);
            }
            catch (Exception e) {
                integer = -1;
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("getIntegerProperty() - Wrong integer property: " + value);
            }
        }
        return integer;
    }

    public boolean getBooleanProperty(Property option) {
        boolean flag;
        block2: {
            String value = this.getProperty(option);
            try {
                flag = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                flag = false;
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("getBooleanProperty() - Wrong boolean property: " + value);
            }
        }
        return flag;
    }

    public String getProperty(Property option) {
        String value = this.validationOptions.getValue(option);
        if (value == null) {
            value = this.applicationProperties.getValue(option);
        }
        return value;
    }

    public String getLabel(Label label) {
        return this.internationalization.getLabel(label);
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
    }

    public Internationalization getInternationalization() {
        return this.internationalization;
    }

    public void setInternationalization(Internationalization internationalization) {
        this.internationalization = internationalization;
    }

    public String getOs() {
        return this.os;
    }

    public boolean isWindows() {
        return this.os.indexOf("win") >= 0;
    }

    public boolean isMac() {
        return this.os.indexOf("mac") >= 0;
    }

    public boolean isUnix() {
        return this.os.indexOf("nix") >= 0 || this.os.indexOf("nux") >= 0 || this.os.indexOf("aix") > 0;
    }

    public boolean isSolaris() {
        return this.os.indexOf("sunos") >= 0;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRunningFromJar() {
        return this.runningFromJar;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "Configuration [applicationProperties=" + String.valueOf(this.applicationProperties) + ", i18n=" + String.valueOf(this.internationalization) + ", options=" + String.valueOf(this.validationOptions) + "]";
    }

    static {
        logger = LoggerFactory.getLogger(Configuration.class);
    }
}

